/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.StrongArmsBreakSpeed;
import com.starshootercity.abilities.VisibleAbility;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StrongArms
implements VisibleAbility,
Listener {
    private static final List<Material> naturalStones = new ArrayList<Material>(){
        {
            this.add(Material.STONE);
            this.add(Material.TUFF);
            this.add(Material.GRANITE);
            this.add(Material.DIORITE);
            this.add(Material.ANDESITE);
            this.add(Material.SANDSTONE);
            this.add(Material.SMOOTH_SANDSTONE);
            this.add(Material.RED_SANDSTONE);
            this.add(Material.SMOOTH_RED_SANDSTONE);
            this.add(Material.DEEPSLATE);
            this.add(Material.BLACKSTONE);
            this.add(Material.NETHERRACK);
        }
    };

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        AbilityRegister.runForAbility((Entity)event.getPlayer(), this.getKey(), () -> {
            if (naturalStones.contains(event.getBlock().getType()) && !Tag.ITEMS_PICKAXES.isTagged((Keyed)event.getPlayer().getInventory().getItemInMainHand().getType())) {
                event.setCancelled(true);
                ItemStack item = new ItemStack(Material.IRON_PICKAXE);
                item.addEnchantments(event.getPlayer().getInventory().getItemInMainHand().getEnchantments());
                event.getBlock().breakNaturally(item, event instanceof StrongArmsBreakSpeed.StrongArmsFastBlockBreakEvent);
            }
        });
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:strong_arms");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You are strong enough to break natural stones without using a pickaxe.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Strong Arms", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }
}

