/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerInventory
implements VisibleAbility,
Listener {
    private static File inventories;
    private static FileConfiguration inventoriesConfig;
    NamespacedKey openedBoxKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "openedbox");

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:shulker_inventory");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You have access to an additional 9 slots of inventory, which keep the items on death.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Hoarder", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    public ShulkerInventory() {
        inventories = new File(OriginsReborn.getInstance().getDataFolder(), "inventories.yml");
        if (!inventories.exists()) {
            boolean ignore = inventories.getParentFile().mkdirs();
            OriginsReborn.getInstance().saveResource("inventories.yml", false);
        }
        inventoriesConfig = new AutosavingYamlConfiguration();
        try {
            inventoriesConfig.load(inventories);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        event.getPlayer().getPersistentDataContainer().set(this.openedBoxKey, PersistentDataType.BOOLEAN, (Object)false);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (event.isRightClick() && event.getSlotType() == InventoryType.SlotType.ARMOR && event.getSlot() == 38) {
                    Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.DISPENSER, (Component)Component.text((String)"Shulker Inventory"));
                    player.openInventory(inventory);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack item = ShulkerInventory.getInventoriesConfig().getItemStack("%s.%s".formatted(player.getUniqueId().toString(), i));
                        if (item == null) continue;
                        inventory.setItem(i, item);
                    }
                    player.getPersistentDataContainer().set(this.openedBoxKey, PersistentDataType.BOOLEAN, (Object)true);
                    return;
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
                    if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.openedBoxKey, PersistentDataType.BOOLEAN))) {
                        for (int i = 0; i < 9; ++i) {
                            ShulkerInventory.getInventoriesConfig().set("%s.%s".formatted(player.getUniqueId().toString(), i), (Object)player.getOpenInventory().getItem(i));
                        }
                    }
                });
            });
        }
    }

    public static FileConfiguration getInventoriesConfig() {
        return inventoriesConfig;
    }

    private static class AutosavingYamlConfiguration
    extends YamlConfiguration {
        private AutosavingYamlConfiguration() {
        }

        public void set(@NotNull String path, @Nullable Object value) {
            super.set(path, value);
            try {
                this.save(inventories);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

