/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class ScareCreepers
implements VisibleAbility,
Listener {
    private final NamespacedKey hitByPlayerKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "hit-by-player");

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:scare_creepers");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("Creepers are scared of you and will only explode if you attack them first.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Catlike Appearance", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            this.fixCreeper(creeper);
        }
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (!(entity instanceof Creeper)) continue;
            Creeper creeper = (Creeper)entity;
            this.fixCreeper(creeper);
        }
    }

    public void fixCreeper(Creeper creeper) {
        Bukkit.getMobGoals().addGoal((Mob)creeper, 0, new PathfinderGoalAvoidTarget((EntityCreature)((CraftEntity)creeper).getHandle(), EntityHuman.class, 6.0f, 1.0, 1.2, livingEntity -> {
            Player player;
            CraftEntity patt2466$temp = livingEntity.getBukkitEntity();
            if (patt2466$temp instanceof Player && AbilityRegister.hasAbility(player = (Player)patt2466$temp, this.getKey())) {
                String data = (String)creeper.getPersistentDataContainer().get(this.hitByPlayerKey, PersistentDataType.STRING);
                if (data == null) {
                    return true;
                }
                return !data.equals(player.getName());
            }
            return false;
        }).asPaperVanillaGoal());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity().getType() != EntityType.CREEPER) return;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile) {
            Player shooter;
            Projectile projectile = (Projectile)entity;
            ProjectileSource projectileSource = projectile.getShooter();
            if (!(projectileSource instanceof Player)) return;
            player = shooter = (Player)projectileSource;
        } else {
            Player damager;
            entity = event.getDamager();
            if (!(entity instanceof Player)) return;
            player = damager = (Player)entity;
        }
        AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> event.getEntity().getPersistentDataContainer().set(this.hitByPlayerKey, PersistentDataType.STRING, (Object)player.getName()));
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().getType() == EntityType.CREEPER && (livingEntity = event.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                String data = (String)event.getEntity().getPersistentDataContainer().get(this.hitByPlayerKey, PersistentDataType.STRING);
                if (data == null) {
                    event.setCancelled(true);
                    return;
                }
                if (!data.equals(player.getName())) {
                    event.setCancelled(true);
                }
            });
        }
    }
}

