/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class PumpkinHate
implements VisibleAbility,
Listener {
    private final Map<Player, List<Player>> ignoringPlayers = new HashMap<Player, List<Player>>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player pumpkinWearer : Bukkit.getOnlinePlayers()) {
            for (Player pumpkinHater : Bukkit.getOnlinePlayers()) {
                AbilityRegister.runForAbility((Entity)pumpkinHater, this.getKey(), () -> {
                    if (pumpkinWearer != pumpkinHater) {
                        ItemStack helmet;
                        if (!this.ignoringPlayers.containsKey(pumpkinHater)) {
                            this.ignoringPlayers.put(pumpkinHater, new ArrayList());
                        }
                        if ((helmet = pumpkinWearer.getInventory().getHelmet()) != null && helmet.getType() == Material.CARVED_PUMPKIN) {
                            if (!this.ignoringPlayers.get(pumpkinHater).contains(pumpkinWearer)) {
                                this.ignoringPlayers.get(pumpkinHater).add(pumpkinWearer);
                            }
                            EntityPlayer hater = ((CraftPlayer)pumpkinHater).getHandle();
                            EntityPlayer wearer = ((CraftPlayer)pumpkinWearer).getHandle();
                            byte data = 32;
                            if (pumpkinWearer.getFireTicks() > 0) {
                                data = (byte)(data + 1);
                            }
                            if (pumpkinWearer.isSneaking()) {
                                data = (byte)(data + 2);
                            }
                            if (pumpkinWearer.isSprinting()) {
                                data = (byte)(data + 8);
                            }
                            if (pumpkinWearer.isSwimming()) {
                                data = (byte)(data + 16);
                            }
                            if (pumpkinWearer.isGlowing()) {
                                data = (byte)(data + 64);
                            }
                            if (pumpkinWearer.isGliding()) {
                                data = (byte)(data + 128);
                            }
                            ArrayList<DataWatcher.b> eData = new ArrayList<DataWatcher.b>();
                            eData.add(DataWatcher.b.a((DataWatcherObject)new DataWatcherObject(0, DataWatcherRegistry.a), (Object)data));
                            PacketPlayOutEntityMetadata metadata = new PacketPlayOutEntityMetadata(wearer.aj(), eData);
                            hater.c.b((Packet)metadata);
                            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                                pumpkinHater.sendEquipmentChange((LivingEntity)pumpkinWearer, equipmentSlot, null);
                            }
                        } else {
                            this.ignoringPlayers.get(pumpkinHater).remove(pumpkinWearer);
                            AbilityRegister.updateEntity(pumpkinHater, (Entity)pumpkinWearer);
                        }
                    }
                });
            }
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        AbilityRegister.runForAbility((Entity)event.getPlayer(), this.getKey(), () -> {
            if (event.getItem().getType() == Material.PUMPKIN_PIE) {
                event.setCancelled(true);
                ItemStack item = event.getItem();
                item.setAmount(item.getAmount() - 1);
                event.getPlayer().getInventory().setItem(event.getHand(), item);
                event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 300, 2, false, true));
                event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 300, 1, false, true));
                event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.POISON, 1200, 1, false, true));
            }
        });
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You are afraid of pumpkins. For a good reason.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Scared of Gourds", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:pumpkin_hate");
    }
}

