/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.BreakSpeedModifierAbility;
import com.starshootercity.abilities.DependantAbility;
import com.starshootercity.abilities.FlightAllowingAbility;
import com.starshootercity.abilities.VisibleAbility;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.kyori.adventure.key.Key;
import net.minecraft.Optionull;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Phasing
implements DependantAbility,
VisibleAbility,
FlightAllowingAbility,
BreakSpeedModifierAbility,
Listener {
    private final List<Material> UNPHASEABLE = List.of(Material.OBSIDIAN, Material.BEDROCK);
    private final Map<Player, Boolean> isPhasing = new HashMap<Player, Boolean>();

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:phasing");
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key((String)"origins:phantomize");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("While phantomized, you can walk through solid material, except Obsidian.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Phasing", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public void onServerTick(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                boolean isInBlock = this.isInBlock((Entity)player);
                this.setPhasing(player, player.isOnGround() && player.isSneaking() && !this.UNPHASEABLE.contains(player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType()) || isInBlock);
                boolean bl = ((CraftPlayer)player).getHandle().af = player.getGameMode() == GameMode.SPECTATOR || this.isPhasing.getOrDefault(player, false) != false;
                if (this.isPhasing.getOrDefault(player, false).booleanValue()) {
                    player.setFallDistance(0.0f);
                    if (player.getAllowFlight()) {
                        player.setFlying(true);
                    }
                }
            }, () -> {
                if (this.isPhasing.getOrDefault(player, false).booleanValue()) {
                    this.setPhasing(player, false);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.isPhasing.getOrDefault(event.getPlayer(), false).booleanValue() && this.isInBlock(event.getTo(), block -> this.UNPHASEABLE.contains(block.getType()))) {
            event.setCancelled(true);
        }
    }

    public boolean isInBlock(Entity entity) {
        return this.isInBlock(entity.getLocation(), block -> block.getType().isSolid() && !this.UNPHASEABLE.contains(block.getType()));
    }

    public boolean isInBlock(Location location, Predicate<Block> predicate) {
        boolean isInsideBlock = false;
        for (Location currentLocation : List.of(location.clone().add(0.0, 1.0, 0.0), location.clone())) {
            List<Double> values = List.of(Double.valueOf(0.4), Double.valueOf(-0.4));
            for (double x : values) {
                for (double z : values) {
                    if (!predicate.test(currentLocation.clone().add(x, 0.0, z).getBlock())) continue;
                    isInsideBlock = true;
                    break;
                }
                if (!isInsideBlock) continue;
                break;
            }
            if (!isInsideBlock) continue;
            break;
        }
        return isInsideBlock;
    }

    @Override
    public boolean canFly(Player player) {
        return this.getDependency().isEnabled(player) && this.isPhasing.getOrDefault(player, false) != false;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
                    event.setCancelled(true);
                }
            });
        }
    }

    @Override
    public float getFlightSpeed(Player player) {
        return 0.1f;
    }

    @Override
    public BreakSpeedModifierAbility.BlockMiningContext provideContextFor(Player player) {
        ItemStack helmet = player.getInventory().getHelmet();
        boolean aquaAffinity = false;
        if (helmet != null) {
            aquaAffinity = helmet.containsEnchantment(Enchantment.WATER_WORKER);
        }
        return new BreakSpeedModifierAbility.BlockMiningContext(player.getInventory().getItemInMainHand(), player.getPotionEffect(PotionEffectType.SLOW_DIGGING), player.getPotionEffect(PotionEffectType.FAST_DIGGING), player.getPotionEffect(PotionEffectType.CONDUIT_POWER), player.isUnderWater(), aquaAffinity, true);
    }

    @Override
    public boolean shouldActivate(Player player) {
        return this.getDependency().isEnabled(player) && this.isPhasing.getOrDefault(player, false) != false;
    }

    private void setPhasing(Player player, boolean enabled) {
        enabled = AbilityRegister.hasAbility(player, this.getKey()) && enabled;
        Block block = player.getEyeLocation().getBlock();
        if (block.getType().isCollidable() && enabled) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, -1, 0, false, false));
        } else {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
        if (this.isPhasing.getOrDefault(player, false) == enabled) {
            return;
        }
        Vector vector = player.getVelocity();
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        EnumGamemode gamemode = enabled ? EnumGamemode.d : serverPlayer.e.b();
        ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(serverPlayer.cw(), serverPlayer.fR(), true, 1, gamemode, serverPlayer.N(), (RemoteChatSession.a)Optionull.a((Object)serverPlayer.ab(), RemoteChatSession::a));
        ClientboundPlayerInfoUpdatePacket packet = new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.c), entry);
        serverPlayer.c.b((Packet)packet);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> player.setVelocity(vector));
        this.isPhasing.put(player, enabled);
    }
}

