/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.starshootercity.abilities.DependantAbility;
import com.starshootercity.abilities.Phantomize;
import net.kyori.adventure.key.Key;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.world.level.border.WorldBorder;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class PhantomizeOverlay
implements DependantAbility,
Listener {
    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:phantomize_overlay");
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key((String)"origins:phantomize");
    }

    @EventHandler
    public void onPhantomizeToggle(Phantomize.PhantomizeToggleEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    @EventHandler
    public void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePhantomizeOverlay(event.getPlayer());
    }

    private void updatePhantomizeOverlay(Player player) {
        WorldBorder border = new WorldBorder();
        border.c(this.getDependency().isEnabled(player) ? (int)player.getWorld().getWorldBorder().getSize() * 2 : player.getWorld().getWorldBorder().getWarningDistance());
        ClientboundSetBorderWarningDistancePacket warningDistancePacket = new ClientboundSetBorderWarningDistancePacket(border);
        ((CraftPlayer)player).getHandle().c.b((Packet)warningDistancePacket);
    }
}

