/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.DependencyAbility;
import com.starshootercity.events.PlayerLeftClickEvent;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class Phantomize
implements DependencyAbility,
Listener {
    private final Map<Player, Boolean> phantomizedPlayers = new HashMap<Player, Boolean>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isEnabled(player) || player.getFoodLevel() > 6) continue;
            this.phantomizedPlayers.put(player, false);
            PhantomizeToggleEvent phantomizeToggleEvent = new PhantomizeToggleEvent(player, false);
            phantomizeToggleEvent.callEvent();
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:phantomize");
    }

    @Override
    public boolean isEnabled(Player player) {
        return this.phantomizedPlayers.getOrDefault(player, false);
    }

    @EventHandler
    public void onLeftClick(PlayerLeftClickEvent event) {
        if (event.hasBlock()) {
            return;
        }
        if (event.getPlayer().getFoodLevel() <= 6) {
            return;
        }
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        AbilityRegister.runForAbility((Entity)event.getPlayer(), this.getKey(), () -> {
            boolean enabling = this.phantomizedPlayers.getOrDefault(event.getPlayer(), false) == false;
            this.phantomizedPlayers.put(event.getPlayer(), enabling);
            PhantomizeToggleEvent phantomizeToggleEvent = new PhantomizeToggleEvent(event.getPlayer(), enabling);
            phantomizeToggleEvent.callEvent();
        });
    }

    public static class PhantomizeToggleEvent
    extends PlayerEvent {
        private final boolean enabling;
        private static final HandlerList HANDLERS = new HandlerList();

        public PhantomizeToggleEvent(Player who, boolean enabling) {
            super(who);
            this.enabling = enabling;
        }

        public boolean isEnabling() {
            return this.enabling;
        }

        @NotNull
        public HandlerList getHandlers() {
            return HANDLERS;
        }

        public static HandlerList getHandlerList() {
            return HANDLERS;
        }
    }
}

