/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.Ability;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public interface ParticleAbility
extends Ability {
    public Particle getParticle();

    public int getFrequency();

    default public int getExtra() {
        return 0;
    }

    default public Object getData() {
        return null;
    }

    public static class ParticleAbilityListener
    implements Listener {
        @EventHandler
        public void onServerTickEnd(ServerTickEndEvent event) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Origin origin = OriginSwapper.getOrigin(player);
                if (origin == null) continue;
                for (Ability ability : origin.getAbilities()) {
                    if (!(ability instanceof ParticleAbility)) continue;
                    ParticleAbility particleAbility = (ParticleAbility)ability;
                    if (event.getTickNumber() % particleAbility.getFrequency() != 0) continue;
                    player.getWorld().spawnParticle(particleAbility.getParticle(), player.getLocation(), 1, 0.5, 1.0, 0.5, (double)particleAbility.getExtra(), particleAbility.getData());
                }
            }
        }
    }
}

