/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.FlightAllowingAbility;
import com.starshootercity.abilities.VisibleAbility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MasterOfWebs
implements FlightAllowingAbility,
Listener,
VisibleAbility {
    private final Map<Player, List<Entity>> glowingEntities = new HashMap<Player, List<Entity>>();
    private final Map<Player, Integer> cobwebSpawnCooldowns = new HashMap<Player, Integer>();
    private final List<Location> temporaryCobwebs = new ArrayList<Location>();
    private final Map<Player, Boolean> canFly = new HashMap<Player, Boolean>();

    @EventHandler
    public void onBlockDropItem(BlockDropItemEvent event) {
        if (this.temporaryCobwebs.contains(event.getBlock().getLocation())) {
            event.setCancelled(true);
            this.temporaryCobwebs.remove(event.getBlock().getLocation());
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                Integer cooldown = this.cobwebSpawnCooldowns.get(player);
                if (!(cooldown != null && Bukkit.getCurrentTick() - cooldown < 120 || event.getEntity().getLocation().getBlock().isSolid())) {
                    this.cobwebSpawnCooldowns.put(player, Bukkit.getCurrentTick());
                    Location location = event.getEntity().getLocation().getBlock().getLocation();
                    this.temporaryCobwebs.add(location);
                    location.getBlock().setType(Material.COBWEB);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
                        if (location.getBlock().getType() == Material.COBWEB && this.temporaryCobwebs.contains(location)) {
                            this.temporaryCobwebs.remove(location);
                            location.getBlock().setType(Material.AIR);
                        }
                    }, 60L);
                }
            });
        }
    }

    private void setCanFly(Player player, boolean setFly) {
        if (setFly) {
            player.setAllowFlight(true);
        }
        this.canFly.put(player, setFly);
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player webMaster : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)webMaster, this.getKey(), () -> {
                if (this.isInCobweb((Entity)webMaster)) {
                    this.setCanFly(webMaster, true);
                    webMaster.setFlying(true);
                } else {
                    this.setCanFly(webMaster, false);
                }
                List<Entity> entities = webMaster.getNearbyEntities(16.0, 16.0, 16.0);
                entities.removeIf(entity -> !(entity instanceof LivingEntity));
                if (entities.size() > 16) {
                    entities = entities.subList(0, 16);
                }
                entities.addAll(Bukkit.getOnlinePlayers());
                entities.removeIf(entity -> entity.getLocation().distance(webMaster.getLocation()) > 16.0);
                for (Entity webStuck : entities) {
                    AbilityRegister.runWithoutAbility(webStuck, this.getKey(), () -> {
                        if (webStuck != webMaster) {
                            if (!this.glowingEntities.containsKey(webMaster)) {
                                this.glowingEntities.put(webMaster, new ArrayList());
                            }
                            if (this.isInCobweb(webStuck)) {
                                if (!this.glowingEntities.get(webMaster).contains(webStuck)) {
                                    this.glowingEntities.get(webMaster).add(webStuck);
                                }
                                EntityPlayer master = ((CraftPlayer)webMaster).getHandle();
                                net.minecraft.world.entity.Entity stuck = ((CraftEntity)webStuck).getHandle();
                                byte data = 64;
                                if (webStuck.getFireTicks() > 0) {
                                    data = (byte)(data + 1);
                                }
                                if (webStuck.isSneaking()) {
                                    data = (byte)(data + 2);
                                }
                                if (webStuck instanceof Player) {
                                    Player stuckPlayer = (Player)webStuck;
                                    if (stuckPlayer.isSprinting()) {
                                        data = (byte)(data + 8);
                                    }
                                    if (stuckPlayer.isSwimming()) {
                                        data = (byte)(data + 16);
                                    }
                                    if (stuckPlayer.isInvisible()) {
                                        data = (byte)(data + 32);
                                    }
                                    if (stuckPlayer.isGliding()) {
                                        data = (byte)(data + 128);
                                    }
                                }
                                ArrayList<DataWatcher.b> eData = new ArrayList<DataWatcher.b>();
                                eData.add(DataWatcher.b.a((DataWatcherObject)new DataWatcherObject(0, DataWatcherRegistry.a), (Object)data));
                                PacketPlayOutEntityMetadata metadata = new PacketPlayOutEntityMetadata(stuck.aj(), eData);
                                master.c.b((Packet)metadata);
                            } else {
                                this.glowingEntities.get(webMaster).remove(webStuck);
                                AbilityRegister.updateEntity(webMaster, webStuck);
                            }
                        }
                    });
                }
            });
        }
    }

    public MasterOfWebs() {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "web-recipe");
        ShapelessRecipe webRecipe = new ShapelessRecipe(recipeKey, new ItemStack(Material.COBWEB));
        if (Bukkit.getRecipe((NamespacedKey)recipeKey) == null) {
            webRecipe.addIngredient(Material.STRING);
            webRecipe.addIngredient(Material.STRING);
            Bukkit.addRecipe((Recipe)webRecipe);
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() == Material.COBWEB) {
            for (HumanEntity entity : event.getInventory().getViewers()) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                AbilityRegister.runWithoutAbility((Entity)player, this.getKey(), () -> event.getInventory().setResult(null));
            }
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:master_of_webs");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You navigate cobweb perfectly, and are able to climb in them. When you hit an enemy in melee, they get stuck in cobweb for a while. Non-arthropods stuck in cobweb will be sensed by you. You are able to craft cobweb from string.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Master of Webs", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    public boolean isInCobweb(final Entity entity) {
        for (Block start : new ArrayList<Block>(){
            {
                this.add(entity.getLocation().getBlock());
                this.add(entity.getLocation().getBlock().getRelative(BlockFace.UP));
            }
        }) {
            if (start.getType() == Material.COBWEB) {
                return true;
            }
            for (BlockFace face : BlockFace.values()) {
                Block block = start.getRelative(face);
                if (block.getType() != Material.COBWEB || !entity.getBoundingBox().overlaps(block.getBoundingBox())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canFly(Player player) {
        return this.canFly.getOrDefault(player, false);
    }

    @Override
    public float getFlightSpeed(Player player) {
        return 0.04f;
    }
}

