/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LightArmor
implements VisibleAbility,
Listener {
    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:light_armor");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You can not wear any heavy armor (armor with protection values higher than chainmail).", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Need for Mobility", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity;
        if (event.getInventorySlots().contains(38) && (humanEntity = event.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            this.checkArmorEvent((Cancellable)event, player, event.getOldCursor());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            ItemStack item;
            Player player = (Player)humanEntity;
            if (Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)event.getCursor().getType()) && event.getSlotType() == InventoryType.SlotType.ARMOR) {
                this.checkArmorEvent((Cancellable)event, player, event.getCursor());
            }
            if (event.isShiftClick()) {
                if (event.getCurrentItem() == null) {
                    return;
                }
                if (event.getInventory().getType() != InventoryType.CRAFTING) {
                    return;
                }
                if (MaterialTags.HELMETS.isTagged(event.getCurrentItem().getType()) && player.getEquipment().getHelmet() == null) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.CHESTPLATES.isTagged(event.getCurrentItem().getType()) && player.getEquipment().getLeggings() == null) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.LEGGINGS.isTagged(event.getCurrentItem().getType()) && player.getEquipment().getLeggings() == null) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
                if (MaterialTags.BOOTS.isTagged(event.getCurrentItem().getType()) && player.getEquipment().getBoots() == null) {
                    this.checkArmorEvent((Cancellable)event, player, event.getCurrentItem());
                }
            }
            if (event.getAction() == InventoryAction.HOTBAR_SWAP && event.getHotbarButton() == -1 && event.getSlotType() == InventoryType.SlotType.ARMOR) {
                this.checkArmorEvent((Cancellable)event, player, player.getInventory().getItemInOffHand());
            }
            if (event.getClick() == ClickType.NUMBER_KEY && event.getSlotType() == InventoryType.SlotType.ARMOR && (item = player.getInventory().getItem(event.getHotbarButton())) != null) {
                this.checkArmorEvent((Cancellable)event, player, item);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().isRightClick()) {
            if (event.getItem() == null) {
                return;
            }
            if (MaterialTags.HELMETS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.CHESTPLATES.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.LEGGINGS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
            if (MaterialTags.BOOTS.isTagged(event.getItem().getType())) {
                this.checkArmorEvent((Cancellable)event, event.getPlayer(), event.getItem());
            }
        }
    }

    @EventHandler
    public void onBlockDispenseArmor(BlockDispenseArmorEvent event) {
        LivingEntity livingEntity = event.getTargetEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.checkArmorEvent((Cancellable)event, player, event.getItem());
        }
    }

    public void checkArmorEvent(Cancellable event, Player player, ItemStack armor) {
        AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
            ArrayList<Material> allowedTypes = new ArrayList<Material>(){
                {
                    this.add(Material.CHAINMAIL_HELMET);
                    this.add(Material.CHAINMAIL_CHESTPLATE);
                    this.add(Material.CHAINMAIL_LEGGINGS);
                    this.add(Material.CHAINMAIL_BOOTS);
                    this.add(Material.LEATHER_HELMET);
                    this.add(Material.LEATHER_CHESTPLATE);
                    this.add(Material.LEATHER_LEGGINGS);
                    this.add(Material.LEATHER_BOOTS);
                    this.add(Material.GOLDEN_HELMET);
                    this.add(Material.GOLDEN_CHESTPLATE);
                    this.add(Material.GOLDEN_LEGGINGS);
                    this.add(Material.GOLDEN_BOOTS);
                }
            };
            if (allowedTypes.contains(armor.getType())) {
                return;
            }
            event.setCancelled(true);
        });
    }
}

