/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.FlightAllowingAbility;
import com.starshootercity.abilities.VisibleAbility;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Climbing
implements FlightAllowingAbility,
Listener,
VisibleAbility {
    NamespacedKey stoppedClimbingKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "stoppedclimbing");
    NamespacedKey startedClimbingKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "startedclimbing");
    private final Map<Player, Boolean> canFly = new HashMap<Player, Boolean>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent ignored) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                boolean anySolid = false;
                boolean anysolidAbove = false;
                for (BlockFace face : new ArrayList<BlockFace>(){
                    {
                        this.add(BlockFace.WEST);
                        this.add(BlockFace.EAST);
                        this.add(BlockFace.NORTH);
                        this.add(BlockFace.SOUTH);
                    }
                }) {
                    anySolid = player.getLocation().getBlock().getRelative(face).isSolid();
                    anysolidAbove = player.getLocation().getBlock().getRelative(BlockFace.UP).getRelative(face).isSolid();
                    if (!anySolid) continue;
                    break;
                }
                this.setCanFly(player, anySolid);
                if (anySolid) {
                    player.setFlyingFallDamage(TriState.TRUE);
                }
                if (player.getAllowFlight() && anysolidAbove) {
                    if (!Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.stoppedClimbingKey, PersistentDataType.BOOLEAN))) {
                        if (!player.isOnGround()) {
                            player.setFlying(true);
                        }
                    } else if (player.isOnGround()) {
                        player.getPersistentDataContainer().set(this.stoppedClimbingKey, PersistentDataType.BOOLEAN, (Object)false);
                    }
                }
            });
        }
    }

    private void setCanFly(Player player, boolean setFly) {
        if (setFly) {
            player.setAllowFlight(true);
        }
        this.canFly.put(player, setFly);
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Long time;
        if (!event.isFlying() && (time = (Long)event.getPlayer().getPersistentDataContainer().get(this.startedClimbingKey, PersistentDataType.LONG)) != null && Instant.now().getEpochSecond() - time < 2L) {
            event.setCancelled(true);
            return;
        }
        event.getPlayer().getPersistentDataContainer().set(this.stoppedClimbingKey, PersistentDataType.BOOLEAN, (Object)(!event.isFlying() ? 1 : 0));
    }

    @EventHandler
    public void onPlayerJump(PlayerJumpEvent event) {
        event.getPlayer().getPersistentDataContainer().set(this.startedClimbingKey, PersistentDataType.LONG, (Object)Instant.now().getEpochSecond());
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:climbing");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You are able to climb up any kind of wall, not just ladders.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Climbing", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @Override
    public boolean canFly(Player player) {
        return this.canFly.getOrDefault(player, false);
    }

    @Override
    public float getFlightSpeed(Player player) {
        return 0.05f;
    }

    @Override
    @NotNull
    public TriState getFlyingFallDamage(Player player) {
        return TriState.TRUE;
    }
}

