/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.SavedPotionEffect;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class CatVision
implements VisibleAbility,
Listener {
    Map<Player, SavedPotionEffect> storedEffects = new HashMap<Player, SavedPotionEffect>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (!player.isUnderWater()) {
                    PotionEffect effect = player.getPotionEffect(PotionEffectType.NIGHT_VISION);
                    boolean ambient = false;
                    boolean showParticles = false;
                    if (effect != null) {
                        ambient = effect.isAmbient();
                        showParticles = effect.hasParticles();
                        if (effect.getAmplifier() != -1) {
                            this.storedEffects.put(player, new SavedPotionEffect(effect, Bukkit.getCurrentTick()));
                            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        }
                    }
                    player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, -1, -1, ambient, showParticles));
                } else {
                    Object effect;
                    if (player.hasPotionEffect(PotionEffectType.NIGHT_VISION) && (effect = player.getPotionEffect(PotionEffectType.NIGHT_VISION)) != null && effect.getAmplifier() == -1) {
                        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    }
                    if (this.storedEffects.containsKey(player)) {
                        effect = this.storedEffects.get(player);
                        this.storedEffects.remove(player);
                        PotionEffect potionEffect = ((SavedPotionEffect)effect).effect();
                        int time = potionEffect.getDuration() - (Bukkit.getCurrentTick() - ((SavedPotionEffect)effect).currentTime());
                        if (time > 0) {
                            player.addPotionEffect(new PotionEffect(potionEffect.getType(), time, potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles()));
                        }
                    }
                }
            });
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event.getPlayer());
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:cat_vision");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You can slightly see in the dark when not in water.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Nocturnal", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }
}

