/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.DependantAbility;
import com.starshootercity.abilities.VisibleAbility;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class BurnInDaylight
implements VisibleAbility,
DependantAbility,
Listener {
    @Override
    public DependantAbility.DependencyType getDependencyType() {
        return DependantAbility.DependencyType.INVERSE;
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent ignored) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                Block block = player.getWorld().getHighestBlockAt(player.getLocation());
                while (MaterialTags.GLASS.isTagged(block) || MaterialTags.GLASS_PANES.isTagged(block) && (double)block.getY() >= player.getY()) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                boolean height = (double)block.getY() < player.getY();
                String overworld = OriginsReborn.getInstance().getConfig().getString("worlds.world");
                if (overworld == null) {
                    overworld = "world";
                    OriginsReborn.getInstance().getConfig().set("worlds.world", (Object)"world");
                    OriginsReborn.getInstance().saveConfig();
                }
                boolean isInOverworld = player.getWorld() == Bukkit.getWorld((String)overworld);
                boolean day = player.getWorld().isDayTime();
                if (height && isInOverworld && day && !player.isInWaterOrRainOrBubbleColumn()) {
                    player.setFireTicks(Math.max(player.getFireTicks(), 60));
                }
            });
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:burn_in_daylight");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You begin to burn in daylight if you are not invisible.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Photoallergic", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @Override
    @NotNull
    public Key getDependencyKey() {
        return Key.key((String)"origins:phantomize");
    }
}

