/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.SavedPotionEffect;
import com.starshootercity.abilities.Ability;
import com.starshootercity.abilities.StrongArmsBreakSpeed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public interface BreakSpeedModifierAbility
extends Ability {
    public BlockMiningContext provideContextFor(Player var1);

    public boolean shouldActivate(Player var1);

    public static class BreakSpeedModifierAbilityListener
    implements Listener {
        Random random = new Random();
        private final Map<Integer, Entity> taskEntityMap = new HashMap<Integer, Entity>();
        private final Map<Integer, Player> taskPlayerMap = new HashMap<Integer, Player>();
        private final Map<Integer, Block> taskBlockMap = new HashMap<Integer, Block>();
        private final Map<Player, Integer> blockbreakingTasks = new HashMap<Player, Integer>();
        Map<Player, SavedPotionEffect> storedEffects = new HashMap<Player, SavedPotionEffect>();

        @EventHandler
        public void onBlockDamage(final BlockDamageEvent event) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OriginsReborn.getInstance(), () -> {
                Origin origin = OriginSwapper.getOrigin(event.getPlayer());
                if (origin == null) {
                    return;
                }
                BreakSpeedModifierAbility speedModifierAbility = null;
                for (Ability ability : origin.getAbilities()) {
                    BreakSpeedModifierAbility modifierAbility;
                    if (!(ability instanceof BreakSpeedModifierAbility) || !(modifierAbility = (BreakSpeedModifierAbility)ability).shouldActivate(event.getPlayer())) continue;
                    speedModifierAbility = modifierAbility;
                    break;
                }
                if (speedModifierAbility == null) {
                    return;
                }
                AtomicInteger time = new AtomicInteger();
                Entity marker = event.getPlayer().getWorld().spawnEntity(event.getPlayer().getLocation(), EntityType.MARKER);
                BreakSpeedModifierAbility finalSpeedModifierAbility = speedModifierAbility;
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)OriginsReborn.getInstance(), () -> {
                    try {
                        BlockMiningContext context = finalSpeedModifierAbility.provideContextFor(event.getPlayer());
                        float damage = BreakSpeedModifierAbilityListener.getBlockDamage(event.getBlock(), context, time.getAndIncrement());
                        if (damage >= 1.0f) {
                            int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                            this.cancelTask(taskNum);
                            StrongArmsBreakSpeed.StrongArmsFastBlockBreakEvent blockBreakEvent = new StrongArmsBreakSpeed.StrongArmsFastBlockBreakEvent(event.getBlock(), event.getPlayer());
                            blockBreakEvent.callEvent();
                            ItemStack handItem = event.getPlayer().getInventory().getItemInMainHand();
                            if (Tag.ITEMS_TOOLS.isTagged((Keyed)handItem.getType())) {
                                ItemMeta patt6261$temp;
                                int unbreakingLevel = handItem.getEnchantmentLevel(Enchantment.DURABILITY) + 1;
                                int itemDamage = 0;
                                if (this.random.nextDouble() <= 1.0 / (double)unbreakingLevel) {
                                    ++itemDamage;
                                }
                                if (event.getBlock().getDrops(context.getHeldItem()).size() == 0 && this.random.nextDouble() <= 1.0 / (double)unbreakingLevel) {
                                    ++itemDamage;
                                }
                                if ((patt6261$temp = handItem.getItemMeta()) instanceof Damageable) {
                                    Damageable damageable = (Damageable)patt6261$temp;
                                    damageable.setDamage(damageable.getDamage() + itemDamage);
                                    if (handItem.getType().getMaxDurability() <= damageable.getDamage()) {
                                        event.getPlayer().broadcastSlotBreak(EquipmentSlot.HAND, (Collection)new ArrayList<Player>(){
                                            {
                                                for (Player player : Bukkit.getOnlinePlayers()) {
                                                    if (player.getWorld() != event.getPlayer().getWorld() || !(player.getLocation().distance(event.getPlayer().getLocation()) < 32.0)) continue;
                                                    this.add(player);
                                                }
                                            }
                                        });
                                        event.getPlayer().getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                                    } else {
                                        handItem.setItemMeta((ItemMeta)damageable);
                                    }
                                }
                            }
                            if (!blockBreakEvent.isCancelled()) {
                                event.getBlock().breakNaturally(event.getPlayer().getInventory().getItemInMainHand(), true, true);
                            }
                            return;
                        }
                        event.getPlayer().sendBlockDamage(event.getBlock().getLocation(), damage, marker);
                        Block target = event.getPlayer().getTargetBlockExact(8, FluidCollisionMode.NEVER);
                        if (target == null || !target.getLocation().equals((Object)event.getBlock().getLocation())) {
                            int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                            this.cancelTask(taskNum);
                        }
                    }
                    catch (NullPointerException e) {
                        int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                        this.cancelTask(taskNum);
                    }
                }, 1L, 0L);
                if (this.blockbreakingTasks.containsKey(event.getPlayer())) {
                    this.cancelTask(this.blockbreakingTasks.get(event.getPlayer()));
                    this.blockbreakingTasks.remove(event.getPlayer());
                }
                this.blockbreakingTasks.put(event.getPlayer(), task);
                this.taskEntityMap.put(task, marker);
                this.taskBlockMap.put(task, event.getBlock());
                this.taskPlayerMap.put(task, event.getPlayer());
            });
        }

        private void cancelTask(int task) {
            Bukkit.getScheduler().cancelTask(task);
            Entity marker = this.taskEntityMap.get(task);
            Player player = this.taskPlayerMap.get(task);
            if (player != null && marker != null) {
                player.sendBlockDamage(this.taskBlockMap.get(task).getLocation(), 0.0f, marker);
                marker.remove();
            }
            this.taskEntityMap.remove(task);
            this.taskBlockMap.remove(task);
            this.taskPlayerMap.remove(task);
        }

        private static float getBlockDamage(Block block, BlockMiningContext context, int time) {
            return (float)(Math.round(BreakSpeedModifierAbilityListener.getDestroySpeed(context, block.getType()) * (float)time * 1000.0f) / 1000) / (float)(block.getDrops(context.getHeldItem()).isEmpty() ? 100 : 30);
        }

        public static float getDestroySpeed(BlockMiningContext context, Material blockType) {
            ItemStack itemstack;
            int i;
            IBlockData block = ((CraftBlockState)blockType.createBlockData().createBlockState()).getHandle();
            net.minecraft.world.item.ItemStack handle = CraftItemStack.asNMSCopy((ItemStack)context.getHeldItem());
            float f = handle != null ? handle.a(block) : 1.0f;
            if (f > 1.0f && (i = (itemstack = context.getHeldItem()).getEnchantmentLevel(Enchantment.DIG_SPEED)) > 0 && !itemstack.isEmpty()) {
                f += (float)(i * i + 1);
            }
            if (context.hasDigSpeed()) {
                f *= 1.0f + (float)(context.getDigSpeedAmplification() + 1) * 0.2f;
            }
            if (context.hasDigSlowdown()) {
                int digSlowdown = context.getDigSlowdown();
                float f1 = switch (digSlowdown) {
                    case 0 -> 0.3f;
                    case 1 -> 0.09f;
                    case 2 -> 0.0027f;
                    default -> 1.0f;
                };
                f *= f1;
            }
            if (context.isUnderwater() && !context.hasAquaAffinity()) {
                f /= 5.0f;
            }
            if (!context.isOnGround()) {
                f /= 5.0f;
            }
            float d = block.n;
            return f / d;
        }

        @EventHandler
        public void onBlockDamage(BlockDamageAbortEvent event) {
            if (this.blockbreakingTasks.containsKey(event.getPlayer())) {
                int taskNum = this.blockbreakingTasks.get(event.getPlayer());
                this.cancelTask(taskNum);
            }
        }

        @EventHandler
        public void onServerTickEnd(ServerTickEndEvent event) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Object effect;
                Origin origin = OriginSwapper.getOrigin(player);
                if (origin == null) continue;
                BreakSpeedModifierAbility speedModifierAbility = null;
                for (Ability ability : origin.getAbilities()) {
                    BreakSpeedModifierAbility modifierAbility;
                    if (!(ability instanceof BreakSpeedModifierAbility) || !(modifierAbility = (BreakSpeedModifierAbility)ability).shouldActivate(player)) continue;
                    speedModifierAbility = modifierAbility;
                    break;
                }
                if (speedModifierAbility != null) {
                    effect = player.getPotionEffect(PotionEffectType.SLOW_DIGGING);
                    boolean ambient = false;
                    boolean showParticles = false;
                    if (effect != null) {
                        ambient = effect.isAmbient();
                        showParticles = effect.hasParticles();
                        if (effect.getAmplifier() != -1) {
                            this.storedEffects.put(player, new SavedPotionEffect((PotionEffect)effect, Bukkit.getCurrentTick()));
                            player.removePotionEffect(PotionEffectType.SLOW_DIGGING);
                        }
                    }
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, -1, -1, ambient, showParticles));
                    continue;
                }
                if (player.hasPotionEffect(PotionEffectType.SLOW_DIGGING) && (effect = player.getPotionEffect(PotionEffectType.SLOW_DIGGING)) != null && effect.getAmplifier() == -1) {
                    player.removePotionEffect(PotionEffectType.SLOW_DIGGING);
                }
                if (!this.storedEffects.containsKey(player)) continue;
                effect = this.storedEffects.get(player);
                this.storedEffects.remove(player);
                PotionEffect potionEffect = ((SavedPotionEffect)effect).effect();
                int time = potionEffect.getDuration() - (Bukkit.getCurrentTick() - ((SavedPotionEffect)effect).currentTime());
                if (time <= 0) continue;
                player.addPotionEffect(new PotionEffect(potionEffect.getType(), time, potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles()));
            }
        }
    }

    public static class BlockMiningContext {
        private final PotionEffect slowDigging;
        private final PotionEffect fastDigging;
        private final PotionEffect conduitPower;
        private final ItemStack heldItem;
        private final boolean underwater;
        private final boolean aquaAffinity;
        private final boolean onGround;

        public BlockMiningContext(ItemStack heldItem, @Nullable PotionEffect slowDigging, @Nullable PotionEffect fastDigging, @Nullable PotionEffect conduitPower, boolean underwater, boolean aquaAffinity, boolean onGround) {
            this.heldItem = heldItem;
            this.slowDigging = slowDigging;
            this.fastDigging = fastDigging;
            this.conduitPower = conduitPower;
            this.underwater = underwater;
            this.aquaAffinity = aquaAffinity;
            this.onGround = onGround;
        }

        public boolean isOnGround() {
            return this.onGround;
        }

        public boolean hasAquaAffinity() {
            return this.aquaAffinity;
        }

        public boolean isUnderwater() {
            return this.underwater;
        }

        public ItemStack getHeldItem() {
            return this.heldItem;
        }

        public boolean hasDigSpeed() {
            return this.fastDigging != null || this.conduitPower != null;
        }

        public boolean hasDigSlowdown() {
            return this.slowDigging != null;
        }

        public int getDigSlowdown() {
            if (this.slowDigging == null) {
                return 0;
            }
            return this.slowDigging.getAmplifier();
        }

        public int getDigSpeedAmplification() {
            int i = 0;
            int j = 0;
            if (this.fastDigging != null) {
                i = this.fastDigging.getAmplifier();
            }
            if (this.conduitPower != null) {
                j = this.conduitPower.getAmplifier();
            }
            return Math.max(i, j);
        }
    }
}

