/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.Ability;
import com.starshootercity.abilities.DependantAbility;
import com.starshootercity.abilities.DependencyAbility;
import com.starshootercity.abilities.FlightAllowingAbility;
import com.starshootercity.abilities.VisibilityChangingAbility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class AbilityRegister {
    public static Map<Key, Ability> abilityMap = new HashMap<Key, Ability>();
    public static Map<Key, DependencyAbility> dependencyAbilityMap = new HashMap<Key, DependencyAbility>();

    public static void registerAbility(Ability ability, JavaPlugin instance) {
        if (ability instanceof DependencyAbility) {
            DependencyAbility dependencyAbility = (DependencyAbility)ability;
            dependencyAbilityMap.put(ability.getKey(), dependencyAbility);
        }
        if (ability instanceof Listener) {
            Listener listener = (Listener)ability;
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)instance);
        }
        abilityMap.put(ability.getKey(), ability);
    }

    public static void runForAbility(Entity entity, Key key, Runnable runnable) {
        AbilityRegister.runForAbility(entity, key, runnable, () -> {});
    }

    public static boolean hasAbility(Player player, Key key) {
        Origin origin = OriginSwapper.getOrigin(player);
        if (origin == null) {
            return false;
        }
        Ability ability = abilityMap.get(key);
        if (ability instanceof DependantAbility) {
            DependantAbility dependantAbility = (DependantAbility)ability;
            return origin.hasAbility(key) && dependantAbility.getDependencyType() == DependantAbility.DependencyType.REGULAR == dependantAbility.getDependency().isEnabled(player);
        }
        return origin.hasAbility(key);
    }

    public static void runForAbility(Entity entity, Key key, Runnable runnable, Runnable other) {
        Player player;
        if (entity instanceof Player && AbilityRegister.hasAbility(player = (Player)entity, key)) {
            runnable.run();
            return;
        }
        other.run();
    }

    public static void runWithoutAbility(Entity entity, Key key, Runnable runnable) {
        AbilityRegister.runForAbility(entity, key, () -> {}, runnable);
    }

    public static boolean canFly(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        Origin origin = OriginSwapper.getOrigin(player);
        if (origin == null) {
            return false;
        }
        for (Ability ability : origin.getAbilities()) {
            FlightAllowingAbility flightAllowingAbility;
            if (!(ability instanceof FlightAllowingAbility) || !(flightAllowingAbility = (FlightAllowingAbility)ability).canFly(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvisible(Player player) {
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return true;
        }
        Origin origin = OriginSwapper.getOrigin(player);
        if (origin == null) {
            return false;
        }
        for (Ability ability : origin.getAbilities()) {
            VisibilityChangingAbility visibilityChangingAbility;
            if (!(ability instanceof VisibilityChangingAbility) || !(visibilityChangingAbility = (VisibilityChangingAbility)ability).isInvisible(player)) continue;
            return true;
        }
        return false;
    }

    public static void updateFlight(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            player.setFlySpeed(0.1f);
            return;
        }
        Origin origin = OriginSwapper.getOrigin(player);
        if (origin == null) {
            return;
        }
        TriState flyingFallDamage = TriState.FALSE;
        float speed = -1.0f;
        for (Ability ability : origin.getAbilities()) {
            FlightAllowingAbility flightAllowingAbility;
            if (!(ability instanceof FlightAllowingAbility) || !(flightAllowingAbility = (FlightAllowingAbility)ability).canFly(player)) continue;
            float abilitySpeed = flightAllowingAbility.getFlightSpeed(player);
            float f = speed = speed == -1.0f ? abilitySpeed : Math.min(speed, abilitySpeed);
            if (flightAllowingAbility.getFlyingFallDamage(player) != TriState.TRUE) continue;
            flyingFallDamage = TriState.TRUE;
        }
        player.setFlyingFallDamage(flyingFallDamage);
        player.setFlySpeed(speed == -1.0f ? 0.0f : speed);
    }

    public static void updateEntity(Player player, Entity target) {
        byte data = 0;
        if (target.getFireTicks() > 0) {
            data = (byte)(data + 1);
        }
        if (target.isSneaking()) {
            data = (byte)(data + 2);
        }
        if (target.isGlowing()) {
            data = (byte)(data + 64);
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (targetPlayer.isSprinting()) {
                data = (byte)(data + 8);
            }
            if (targetPlayer.isSwimming()) {
                data = (byte)(data + 16);
            }
            if (targetPlayer.isInvisible()) {
                data = (byte)(data + 32);
            }
            if (targetPlayer.isGliding()) {
                data = (byte)(data + 128);
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                player.sendEquipmentChange((LivingEntity)targetPlayer, equipmentSlot, targetPlayer.getInventory().getItem(equipmentSlot));
            }
        }
        ArrayList<DataWatcher.b> eData = new ArrayList<DataWatcher.b>();
        eData.add(DataWatcher.b.a((DataWatcherObject)new DataWatcherObject(0, DataWatcherRegistry.a), (Object)data));
        PacketPlayOutEntityMetadata metadata = new PacketPlayOutEntityMetadata(((CraftEntity)target).getHandle().aj(), eData);
        ((CraftPlayer)player).getHandle().c.b((Packet)metadata);
    }
}

