/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.OrbOfOrigin;
import com.starshootercity.OriginLoader;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsAddon;
import com.starshootercity.PackApplier;
import com.starshootercity.abilities.Ability;
import com.starshootercity.abilities.AerialCombatant;
import com.starshootercity.abilities.AirFromPotions;
import com.starshootercity.abilities.AquaAffinity;
import com.starshootercity.abilities.Aquatic;
import com.starshootercity.abilities.Arthropod;
import com.starshootercity.abilities.BreakSpeedModifierAbility;
import com.starshootercity.abilities.BurnInDaylight;
import com.starshootercity.abilities.BurningWrath;
import com.starshootercity.abilities.Carnivore;
import com.starshootercity.abilities.CatVision;
import com.starshootercity.abilities.Claustrophobia;
import com.starshootercity.abilities.Climbing;
import com.starshootercity.abilities.DamageFromPotions;
import com.starshootercity.abilities.DamageFromSnowballs;
import com.starshootercity.abilities.Elytra;
import com.starshootercity.abilities.EnderParticles;
import com.starshootercity.abilities.FallImmunity;
import com.starshootercity.abilities.FireImmunity;
import com.starshootercity.abilities.FlameParticles;
import com.starshootercity.abilities.Fragile;
import com.starshootercity.abilities.FreshAir;
import com.starshootercity.abilities.Hotblooded;
import com.starshootercity.abilities.HungerOverTime;
import com.starshootercity.abilities.Invisibility;
import com.starshootercity.abilities.LaunchIntoAir;
import com.starshootercity.abilities.LayEggs;
import com.starshootercity.abilities.LightArmor;
import com.starshootercity.abilities.LikeWater;
import com.starshootercity.abilities.MasterOfWebs;
import com.starshootercity.abilities.MoreExhaustion;
import com.starshootercity.abilities.MoreKineticDamage;
import com.starshootercity.abilities.NaturalArmor;
import com.starshootercity.abilities.NetherSpawn;
import com.starshootercity.abilities.NineLives;
import com.starshootercity.abilities.ParticleAbility;
import com.starshootercity.abilities.Phantomize;
import com.starshootercity.abilities.PhantomizeOverlay;
import com.starshootercity.abilities.Phasing;
import com.starshootercity.abilities.PumpkinHate;
import com.starshootercity.abilities.ScareCreepers;
import com.starshootercity.abilities.ShulkerInventory;
import com.starshootercity.abilities.SlowFalling;
import com.starshootercity.abilities.SprintJump;
import com.starshootercity.abilities.StrongArms;
import com.starshootercity.abilities.StrongArmsBreakSpeed;
import com.starshootercity.abilities.SwimSpeed;
import com.starshootercity.abilities.Tailwind;
import com.starshootercity.abilities.ThrowEnderPearl;
import com.starshootercity.abilities.Unwieldy;
import com.starshootercity.abilities.Vegetarian;
import com.starshootercity.abilities.VelvetPaws;
import com.starshootercity.abilities.WaterBreathing;
import com.starshootercity.abilities.WaterVision;
import com.starshootercity.abilities.WaterVulnerability;
import com.starshootercity.abilities.WeakArms;
import com.starshootercity.commands.OriginCommand;
import com.starshootercity.events.PlayerLeftClickEvent;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class OriginsReborn
extends OriginsAddon {
    private static OriginsReborn instance;
    private Economy economy;
    private boolean vaultEnabled;

    public static OriginsReborn getInstance() {
        return instance;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    private boolean setupEconomy() {
        try {
            RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                this.economy = (Economy)economyProvider.getProvider();
            }
            return this.economy != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public boolean isVaultEnabled() {
        return this.vaultEnabled;
    }

    public void updateConfig() {
        String version = this.getConfig().getString("config-version", "1.0.0");
        if (version.equals("1.0.0")) {
            this.saveResource("config.yml", true);
        } else if (version.equals("2.0.0")) {
            this.getConfig().set("config-version", (Object)"2.0.3");
            this.getConfig().set("display.enable-prefixes", (Object)false);
            this.getConfig().setComments("display", List.of("Miscellaneous display options"));
            this.getConfig().setComments("display.enable-prefixes", List.of("Enable prefixes in tab and on display names with the names of origins"));
            this.saveConfig();
        }
    }

    @Override
    public void onRegister() {
        instance = this;
        if (this.getConfig().getBoolean("swap-command.vault.enabled")) {
            this.vaultEnabled = this.setupEconomy();
            if (!this.vaultEnabled) {
                this.getLogger().warning("Vault is missing, origin swaps will not cost currency");
            }
        } else {
            this.vaultEnabled = false;
        }
        this.saveDefaultConfig();
        this.updateConfig();
        PluginCommand command = this.getCommand("origin");
        if (command != null) {
            command.setExecutor((CommandExecutor)new OriginCommand());
        }
        OriginLoader.register(this);
        Bukkit.getPluginManager().registerEvents((Listener)new OriginSwapper(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OrbOfOrigin(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PackApplier(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerLeftClickEvent.PlayerLeftClickEventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ParticleAbility.ParticleAbilityListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BreakSpeedModifierAbility.BreakSpeedModifierAbilityListener(), (Plugin)this);
    }

    @Override
    @NotNull
    public List<Ability> getAbilities() {
        return List.of(new PumpkinHate(), new FallImmunity(), new WeakArms(), new Fragile(), new SlowFalling(), new FreshAir(), new Vegetarian(), new LayEggs(), new Unwieldy(), new MasterOfWebs(), new Tailwind(), new Arthropod(), new Climbing(), new Carnivore(), new WaterBreathing(), new WaterVision(), new CatVision(), new NineLives(), new BurnInDaylight(), new WaterVulnerability(), new Phantomize(), new Invisibility(), new ThrowEnderPearl(), new PhantomizeOverlay(), new FireImmunity(), new AirFromPotions(), new SwimSpeed(), new LikeWater(), new LightArmor(), new MoreKineticDamage(), new DamageFromPotions(), new DamageFromSnowballs(), new Hotblooded(), new BurningWrath(), new SprintJump(), new AerialCombatant(), new Elytra(), new LaunchIntoAir(), new HungerOverTime(), new MoreExhaustion(), new Aquatic(), new NetherSpawn(), new Claustrophobia(), new VelvetPaws(), new AquaAffinity(), new FlameParticles(), new EnderParticles(), new Phasing(), new ScareCreepers(), new StrongArms(), new StrongArmsBreakSpeed(), new ShulkerInventory(), new NaturalArmor());
    }
}

