/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginLoader;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.Ability;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.AttributeModifierAbility;
import com.starshootercity.abilities.DefaultSpawnAbility;
import com.starshootercity.abilities.ShulkerInventory;
import com.starshootercity.abilities.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.geysermc.GeyserSwapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.world.level.border.WorldBorder;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.geysermc.api.Geyser;
import org.geysermc.geyser.api.GeyserApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginSwapper
implements Listener {
    private static final NamespacedKey displayKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "display-item");
    private static final NamespacedKey confirmKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "confirm-select");
    private static final NamespacedKey costsCurrencyKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "costs-currency");
    private static final NamespacedKey originKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "origin-name");
    private static final NamespacedKey swapTypeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "swap-type");
    private static final NamespacedKey pageSetKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "page-set");
    private static final NamespacedKey pageScrollKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "page-scroll");
    private static final NamespacedKey costKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "enable-cost");
    private static final NamespacedKey displayOnlyKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "display-only");
    private static final NamespacedKey closeKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "close");
    private static final Random random = new Random();
    public static Map<Player, Long> orbCooldown = new HashMap<Player, Long>();
    private static final Map<Player, PlayerSwapOriginEvent.SwapReason> lastSwapReasons = new HashMap<Player, PlayerSwapOriginEvent.SwapReason>();
    private final Map<Player, PlayerRespawnEvent.RespawnReason> lastRespawnReasons = new HashMap<Player, PlayerRespawnEvent.RespawnReason>();
    private static File originFile;
    private static FileConfiguration originFileConfiguration;

    public static String getInverse(String string) {
        StringBuilder result = new StringBuilder();
        for (char c : string.toCharArray()) {
            result.append(OriginSwapper.getInverse(c));
        }
        return result.toString();
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount) {
        OriginSwapper.openOriginSwapper(player, reason, slot, scrollAmount, false, false);
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount, boolean cost) {
        OriginSwapper.openOriginSwapper(player, reason, slot, scrollAmount, cost, false);
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, int slot, int scrollAmount, boolean cost, boolean displayOnly) {
        lastSwapReasons.put(player, reason);
        boolean enableRandom = OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.random-option.enabled");
        if (GeyserSwapper.checkBedrockSwap(player, reason, cost, displayOnly)) {
            LineData data;
            char impact;
            String name;
            ItemStack icon;
            if (OriginLoader.origins.isEmpty()) {
                return;
            }
            ArrayList<Origin> origins = new ArrayList<Origin>(OriginLoader.origins);
            if (!displayOnly) {
                origins.removeIf(Origin::isUnchoosable);
            }
            while (slot > origins.size() || slot == origins.size() && !enableRandom) {
                slot -= origins.size() + (enableRandom ? 1 : 0);
            }
            while (slot < 0) {
                slot += origins.size() + (enableRandom ? 1 : 0);
            }
            if (slot == origins.size()) {
                List excludedOrigins = OriginsReborn.getInstance().getConfig().getStringList("origin-selection.random-option.exclude");
                icon = OrbOfOrigin.orb;
                name = "Random";
                impact = '\ue002';
                StringBuilder names = new StringBuilder("You'll be assigned one of the following:\n\n");
                for (Origin origin : origins) {
                    if (excludedOrigins.contains(origin.getName())) continue;
                    names.append(origin.getName()).append("\n");
                }
                data = new LineData(LineData.makeLineFor(names.toString(), LineData.LineComponent.LineType.DESCRIPTION));
            } else {
                Origin origin = (Origin)origins.get(slot);
                icon = origin.getIcon();
                name = origin.getName();
                impact = origin.getImpact();
                data = new LineData(origin);
            }
            StringBuilder compressedName = new StringBuilder("\uf001");
            for (Object c : (StringBuilder)name.toCharArray()) {
                compressedName.append((char)c);
                compressedName.append('\uf000');
            }
            Component component = Component.text((String)("\uf000\ue000\uf001\ue001\uf002" + impact)).font(Key.key((String)"minecraft:origin_selector")).color((TextColor)NamedTextColor.WHITE).append(Component.text((String)compressedName.toString()).font(Key.key((String)"minecraft:origin_title_text")).color((TextColor)NamedTextColor.WHITE)).append(Component.text((String)(OriginSwapper.getInverse(name) + "\uf000")).font(Key.key((String)"minecraft:reverse_text")).color((TextColor)NamedTextColor.WHITE));
            for (Component c : data.getLines(scrollAmount)) {
                component = component.append(c);
            }
            Inventory swapperInventory = Bukkit.createInventory(null, (int)54, (Component)component);
            ItemMeta meta = icon.getItemMeta();
            meta.getPersistentDataContainer().set(originKey, PersistentDataType.STRING, (Object)name.toLowerCase());
            if (meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer((OfflinePlayer)player);
            }
            meta.getPersistentDataContainer().set(displayKey, PersistentDataType.BOOLEAN, (Object)true);
            meta.getPersistentDataContainer().set(swapTypeKey, PersistentDataType.STRING, (Object)reason.getReason());
            icon.setItemMeta(meta);
            swapperInventory.setItem(1, icon);
            ItemStack confirm = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemStack invisibleConfirm = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta confirmMeta = confirm.getItemMeta();
            ItemMeta invisibleConfirmMeta = invisibleConfirm.getItemMeta();
            confirmMeta.displayName(((TextComponent)Component.text((String)"Confirm").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            confirmMeta.setCustomModelData(Integer.valueOf(5));
            if (!displayOnly) {
                confirmMeta.getPersistentDataContainer().set(confirmKey, PersistentDataType.BOOLEAN, (Object)true);
            } else {
                confirmMeta.getPersistentDataContainer().set(closeKey, PersistentDataType.BOOLEAN, (Object)true);
            }
            invisibleConfirmMeta.displayName(((TextComponent)Component.text((String)"Confirm").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            invisibleConfirmMeta.setCustomModelData(Integer.valueOf(6));
            if (!displayOnly) {
                invisibleConfirmMeta.getPersistentDataContainer().set(confirmKey, PersistentDataType.BOOLEAN, (Object)true);
            } else {
                invisibleConfirmMeta.getPersistentDataContainer().set(closeKey, PersistentDataType.BOOLEAN, (Object)true);
            }
            if (cost && !player.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.vault.bypass-permission", "originsreborn.costbypass"))) {
                String symbol = OriginsReborn.getInstance().getConfig().getString("swap-command.vault.currency-symbol", "$");
                int amount = OriginsReborn.getInstance().getConfig().getInt("swap-command.vault.cost", 1000);
                List<TextComponent> costsCurrency = List.of(Component.text((String)(OriginsReborn.getInstance().getEconomy().has((OfflinePlayer)player, (double)amount) ? "This will cost %s%s of your balance!" : "You need at least %s%s in your balance to do this!").formatted(symbol, amount)));
                confirmMeta.lore(costsCurrency);
                invisibleConfirmMeta.lore(costsCurrency);
                confirmMeta.getPersistentDataContainer().set(costsCurrencyKey, PersistentDataType.BOOLEAN, (Object)true);
                invisibleConfirmMeta.getPersistentDataContainer().set(costsCurrencyKey, PersistentDataType.BOOLEAN, (Object)true);
            }
            ItemStack up = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemStack down = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
            ItemMeta upMeta = up.getItemMeta();
            ItemMeta downMeta = down.getItemMeta();
            int scrollSize = OriginsReborn.getInstance().getConfig().getInt("origin-selection.scroll-amount", 1);
            upMeta.displayName(((TextComponent)Component.text((String)"Up").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            if (scrollAmount != 0) {
                upMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)slot);
                upMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)Math.max(scrollAmount - scrollSize, 0));
            }
            upMeta.setCustomModelData(Integer.valueOf(3 + (scrollAmount == 0 ? 6 : 0)));
            upMeta.getPersistentDataContainer().set(costKey, PersistentDataType.BOOLEAN, (Object)cost);
            upMeta.getPersistentDataContainer().set(displayOnlyKey, PersistentDataType.BOOLEAN, (Object)displayOnly);
            int size = data.lines.size() - scrollAmount - 6;
            boolean canGoDown = size > 0;
            downMeta.displayName(((TextComponent)Component.text((String)"Down").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
            if (canGoDown) {
                downMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)slot);
                downMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)Math.min(scrollAmount + scrollSize, scrollAmount + size));
            }
            downMeta.setCustomModelData(Integer.valueOf(4 + (!canGoDown ? 6 : 0)));
            downMeta.getPersistentDataContainer().set(costKey, PersistentDataType.BOOLEAN, (Object)cost);
            downMeta.getPersistentDataContainer().set(displayOnlyKey, PersistentDataType.BOOLEAN, (Object)displayOnly);
            up.setItemMeta(upMeta);
            down.setItemMeta(downMeta);
            swapperInventory.setItem(52, up);
            swapperInventory.setItem(53, down);
            if (!displayOnly) {
                ItemStack left = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                ItemStack right = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                ItemMeta leftMeta = left.getItemMeta();
                ItemMeta rightMeta = right.getItemMeta();
                leftMeta.displayName(((TextComponent)Component.text((String)"Previous origin").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
                leftMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)(slot - 1));
                leftMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)0);
                leftMeta.setCustomModelData(Integer.valueOf(1));
                leftMeta.getPersistentDataContainer().set(costKey, PersistentDataType.BOOLEAN, (Object)cost);
                leftMeta.getPersistentDataContainer().set(displayOnlyKey, PersistentDataType.BOOLEAN, (Object)false);
                rightMeta.displayName(((TextComponent)Component.text((String)"Next origin").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
                rightMeta.getPersistentDataContainer().set(pageSetKey, PersistentDataType.INTEGER, (Object)(slot + 1));
                rightMeta.getPersistentDataContainer().set(pageScrollKey, PersistentDataType.INTEGER, (Object)0);
                rightMeta.setCustomModelData(Integer.valueOf(2));
                rightMeta.getPersistentDataContainer().set(costKey, PersistentDataType.BOOLEAN, (Object)cost);
                rightMeta.getPersistentDataContainer().set(displayOnlyKey, PersistentDataType.BOOLEAN, (Object)false);
                left.setItemMeta(leftMeta);
                right.setItemMeta(rightMeta);
                swapperInventory.setItem(47, left);
                swapperInventory.setItem(51, right);
            }
            confirm.setItemMeta(confirmMeta);
            invisibleConfirm.setItemMeta(invisibleConfirmMeta);
            swapperInventory.setItem(48, confirm);
            swapperInventory.setItem(49, invisibleConfirm);
            swapperInventory.setItem(50, invisibleConfirm);
            player.openInventory(swapperInventory);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item = event.getWhoClicked().getOpenInventory().getItem(1);
        if (item != null) {
            HumanEntity humanEntity;
            if (item.getItemMeta() == null) {
                return;
            }
            if (item.getItemMeta().getPersistentDataContainer().has(displayKey)) {
                event.setCancelled(true);
            }
            if ((humanEntity = event.getWhoClicked()) instanceof Player) {
                Player player = (Player)humanEntity;
                ItemStack currentItem = event.getCurrentItem();
                if (currentItem == null || currentItem.getItemMeta() == null) {
                    return;
                }
                Integer page = (Integer)currentItem.getItemMeta().getPersistentDataContainer().get(pageSetKey, PersistentDataType.INTEGER);
                if (page != null) {
                    boolean cost = (Boolean)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(costKey, PersistentDataType.BOOLEAN, (Object)false);
                    boolean allowUnchoosable = (Boolean)currentItem.getItemMeta().getPersistentDataContainer().getOrDefault(displayOnlyKey, PersistentDataType.BOOLEAN, (Object)false);
                    Integer scroll = (Integer)currentItem.getItemMeta().getPersistentDataContainer().get(pageScrollKey, PersistentDataType.INTEGER);
                    if (scroll == null) {
                        return;
                    }
                    player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 1.0f);
                    OriginSwapper.openOriginSwapper(player, this.getReason(item), page, scroll, cost, allowUnchoosable);
                }
                if (currentItem.getItemMeta().getPersistentDataContainer().has(confirmKey)) {
                    Origin origin;
                    String originName;
                    int amount = OriginsReborn.getInstance().getConfig().getInt("swap-command.vault.cost", 1000);
                    if (!player.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.vault.bypass-permission", "originsreborn.costbypass")) && Boolean.TRUE.equals(currentItem.getItemMeta().getPersistentDataContainer().get(costsCurrencyKey, PersistentDataType.BOOLEAN))) {
                        if (!OriginsReborn.getInstance().getEconomy().has((OfflinePlayer)player, (double)amount)) {
                            return;
                        }
                        OriginsReborn.getInstance().getEconomy().withdrawPlayer((OfflinePlayer)player, (double)amount);
                    }
                    if ((originName = (String)item.getItemMeta().getPersistentDataContainer().get(originKey, PersistentDataType.STRING)) == null) {
                        return;
                    }
                    if (originName.equalsIgnoreCase("random")) {
                        List excludedOrigins = OriginsReborn.getInstance().getConfig().getStringList("origin-selection.random-option.exclude");
                        ArrayList<Origin> origins = new ArrayList<Origin>(OriginLoader.origins);
                        origins.removeIf(origin1 -> excludedOrigins.contains(origin1.getName()));
                        origins.removeIf(Origin::isUnchoosable);
                        origin = origins.isEmpty() ? OriginLoader.origins.get(0) : (Origin)origins.get(random.nextInt(origins.size()));
                    } else {
                        origin = OriginLoader.originNameMap.get(originName);
                    }
                    PlayerSwapOriginEvent.SwapReason reason = this.getReason(item);
                    player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, SoundCategory.MASTER, 1.0f, 1.0f);
                    player.closeInventory();
                    ItemMeta meta = player.getInventory().getItemInMainHand().getItemMeta();
                    if (reason == PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN) {
                        ItemMeta offhandMeta;
                        EquipmentSlot hand = null;
                        if (meta != null && meta.getPersistentDataContainer().has(OrbOfOrigin.orbKey)) {
                            hand = EquipmentSlot.HAND;
                        }
                        if (hand == null && (offhandMeta = player.getInventory().getItemInOffHand().getItemMeta()) != null && offhandMeta.getPersistentDataContainer().has(OrbOfOrigin.orbKey)) {
                            hand = EquipmentSlot.OFF_HAND;
                        }
                        if (hand == null) {
                            return;
                        }
                        orbCooldown.put(player, System.currentTimeMillis());
                        player.swingHand(hand);
                        if (OriginsReborn.getInstance().getConfig().getBoolean("orb-of-origin.consume")) {
                            player.getInventory().getItem(hand).setAmount(player.getInventory().getItem(hand).getAmount() - 1);
                        }
                    }
                    boolean resetPlayer = OriginSwapper.shouldResetPlayer(reason);
                    OriginSwapper.setOrigin(player, origin, reason, resetPlayer);
                } else if (currentItem.getItemMeta().getPersistentDataContainer().has(closeKey)) {
                    event.getWhoClicked().closeInventory();
                }
            }
        }
    }

    public static boolean shouldResetPlayer(PlayerSwapOriginEvent.SwapReason reason) {
        return switch (reason) {
            case PlayerSwapOriginEvent.SwapReason.COMMAND -> OriginsReborn.getInstance().getConfig().getBoolean("swap-command.reset-player");
            case PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN -> OriginsReborn.getInstance().getConfig().getBoolean("orb-of-origin.reset-player");
            default -> false;
        };
    }

    public static int getWidth(char c) {
        return switch (c) {
            case '!', '\'', ',', '.', ':', ';', 'i', '|', '\uf00a' -> 2;
            case '`', 'l' -> 3;
            case ' ', '\"', '(', ')', '*', 'I', '[', ']', 't', '{', '}' -> 4;
            case '<', '>', 'f', 'k' -> 5;
            case '#', '$', '%', '&', '+', '-', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '=', '?', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\\', '^', '_', 'a', 'b', 'c', 'd', 'e', 'g', 'h', 'j', 'm', 'n', 'o', 'p', 'q', 'r', 's', 'u', 'v', 'w', 'x', 'y', 'z' -> 6;
            case '@', '~' -> 7;
            default -> throw new IllegalStateException("Unexpected value: " + c);
        };
    }

    public static int getWidth(String s) {
        int result = 0;
        for (char c : s.toCharArray()) {
            result += OriginSwapper.getWidth(c);
        }
        return result;
    }

    public static char getInverse(char c) {
        return switch (OriginSwapper.getWidth(c)) {
            case 2 -> '\uf001';
            case 3 -> '\uf002';
            case 4 -> '\uf003';
            case 5 -> '\uf004';
            case 6 -> '\uf005';
            case 7 -> '\uf006';
            case 8 -> '\uf007';
            case 9 -> '\uf008';
            case 10 -> '\uf009';
            default -> throw new IllegalStateException("Unexpected value: " + c);
        };
    }

    public static void resetPlayer(final Player player, boolean full) {
        OriginSwapper.resetAttributes(player);
        player.closeInventory();
        ClientboundSetBorderWarningDistancePacket warningDistancePacket = new ClientboundSetBorderWarningDistancePacket(new WorldBorder(){
            {
                this.c(player.getWorld().getWorldBorder().getWarningDistance());
            }
        });
        ((CraftPlayer)player).getHandle().c.b((Packet)warningDistancePacket);
        player.setCooldown(Material.SHIELD, 0);
        player.setAllowFlight(false);
        player.setFlying(false);
        for (Player otherPlayer : Bukkit.getOnlinePlayers()) {
            AbilityRegister.updateEntity(player, (Entity)otherPlayer);
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (effect.getAmplifier() != -1 && effect.getDuration() != -1) continue;
            player.removePotionEffect(effect.getType());
        }
        if (!full) {
            return;
        }
        player.getInventory().clear();
        player.getEnderChest().clear();
        player.setSaturation(5.0f);
        player.setFallDistance(0.0f);
        player.setRemainingAir(player.getMaximumAir());
        player.setFoodLevel(20);
        player.setFireTicks(0);
        player.setHealth(OriginSwapper.getMaxHealth(player));
        ShulkerInventory.getInventoriesConfig().set(player.getUniqueId().toString(), null);
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        World world = OriginSwapper.getRespawnWorld(OriginSwapper.getOrigin(player));
        player.teleport(world.getSpawnLocation());
        player.setBedSpawnLocation(null);
    }

    @NotNull
    public static World getRespawnWorld(@Nullable Origin origin) {
        World world;
        String overworld;
        if (origin != null) {
            for (Ability ability : origin.getAbilities()) {
                DefaultSpawnAbility defaultSpawnAbility;
                World world2;
                if (!(ability instanceof DefaultSpawnAbility) || (world2 = (defaultSpawnAbility = (DefaultSpawnAbility)ability).getWorld()) == null) continue;
                return world2;
            }
        }
        if ((overworld = OriginsReborn.getInstance().getConfig().getString("worlds.world")) == null) {
            overworld = "world";
            OriginsReborn.getInstance().getConfig().set("worlds.world", (Object)"world");
            OriginsReborn.getInstance().saveConfig();
        }
        if ((world = Bukkit.getWorld((String)overworld)) == null) {
            return (World)Bukkit.getWorlds().get(0);
        }
        return world;
    }

    public static double getMaxHealth(Player player) {
        OriginSwapper.applyAttributeChanges(player);
        AttributeInstance instance = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (instance == null) {
            return 20.0;
        }
        return instance.getValue();
    }

    public static void applyAttributeChanges(Player player) {
        Origin origin = OriginSwapper.getOrigin(player);
        if (origin == null) {
            return;
        }
        for (Ability ability : AbilityRegister.abilityMap.values()) {
            AttributeModifierAbility attributeModifierAbility;
            AttributeInstance instance;
            if (!(ability instanceof AttributeModifierAbility) || (instance = player.getAttribute((attributeModifierAbility = (AttributeModifierAbility)ability).getAttribute())) == null) continue;
            UUID u = UUID.nameUUIDFromBytes(StringUtils.getBytes((String)ability.getKey().asString(), (Charset)null));
            if (origin.hasAbility(ability.getKey())) {
                AttributeModifier modifier = instance.getModifier(u);
                if (modifier != null) {
                    if (modifier.getAmount() == attributeModifierAbility.getTotalAmount(player)) continue;
                    instance.removeModifier(modifier);
                }
                instance.addModifier(new AttributeModifier(u, attributeModifierAbility.getKey().asString(), attributeModifierAbility.getTotalAmount(player), attributeModifierAbility.getOperation()));
                continue;
            }
            if (instance.getModifier(u) == null) continue;
            instance.removeModifier(u);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        OriginSwapper.resetAttributes(event.getPlayer());
        Origin origin = OriginSwapper.getOrigin(event.getPlayer());
        if (origin != null) {
            if (origin.getTeam() == null) {
                return;
            }
            origin.getTeam().addPlayer((OfflinePlayer)event.getPlayer());
        } else if (GeyserApi.api().isBedrockPlayer(event.getPlayer().getUniqueId())) {
            GeyserSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, false, false);
        } else {
            OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, 0, 0);
        }
    }

    public static void resetAttributes(Player player) {
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) continue;
            for (AttributeModifier modifier : instance.getModifiers()) {
                instance.removeModifier(modifier);
            }
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (OriginSwapper.getOrigin(player) != null || player.isDead() || player.getOpenInventory().getType() == InventoryType.CHEST || Geyser.api().isBedrockPlayer(player.getUniqueId())) continue;
            if (OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.randomise")) {
                this.selectRandomOrigin(player, PlayerSwapOriginEvent.SwapReason.INITIAL);
                continue;
            }
            OriginSwapper.openOriginSwapper(player, PlayerSwapOriginEvent.SwapReason.INITIAL, 0, 0);
        }
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.updateFlight(player);
            player.setAllowFlight(AbilityRegister.canFly(player));
            player.setInvisible(AbilityRegister.isInvisible(player));
            OriginSwapper.applyAttributeChanges(player);
            if (OriginSwapper.getOrigin(player) != null || player.getOpenInventory().getType() == InventoryType.CHEST) continue;
            try {
                if (GeyserApi.api().isBedrockPlayer(player.getUniqueId())) continue;
                OriginSwapper.openOriginSwapper(player, lastSwapReasons.getOrDefault(player, PlayerSwapOriginEvent.SwapReason.INITIAL), 0, 0);
            }
            catch (NoClassDefFoundError e) {
                OriginSwapper.openOriginSwapper(player, lastSwapReasons.getOrDefault(player, PlayerSwapOriginEvent.SwapReason.INITIAL), 0, 0);
            }
        }
    }

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        if ((event.getReason() == PlayerSwapOriginEvent.SwapReason.INITIAL || event.getReason() == PlayerSwapOriginEvent.SwapReason.DIED) && event.getPlayer().getBedSpawnLocation() == null) {
            event.getPlayer().teleport(OriginSwapper.getRespawnWorld(OriginSwapper.getOrigin(event.getPlayer())).getSpawnLocation());
        }
    }

    public void selectRandomOrigin(Player player, PlayerSwapOriginEvent.SwapReason reason) {
        Origin origin = OriginLoader.origins.get(random.nextInt(OriginLoader.origins.size()));
        OriginSwapper.setOrigin(player, origin, reason, OriginSwapper.shouldResetPlayer(reason));
        OriginSwapper.openOriginSwapper(player, reason, OriginLoader.origins.indexOf(origin), 0, false, true);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (event.getPlayer().getBedSpawnLocation() == null) {
            World world = OriginSwapper.getRespawnWorld(OriginSwapper.getOrigin(event.getPlayer()));
            event.setRespawnLocation(world.getSpawnLocation());
        }
        this.lastRespawnReasons.put(event.getPlayer(), event.getRespawnReason());
    }

    @EventHandler
    public void onPlayerPostRespawn(PlayerPostRespawnEvent event) {
        if (this.lastRespawnReasons.get(event.getPlayer()) != PlayerRespawnEvent.RespawnReason.DEATH) {
            return;
        }
        FileConfiguration config = OriginsReborn.getInstance().getConfig();
        if (config.getBoolean("origin-selection.death-origin-change")) {
            OriginSwapper.setOrigin(event.getPlayer(), null, PlayerSwapOriginEvent.SwapReason.DIED, false);
            if (OriginsReborn.getInstance().getConfig().getBoolean("origin-selection.randomise")) {
                this.selectRandomOrigin(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL);
            } else {
                OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.INITIAL, 0, 0);
            }
        }
    }

    public PlayerSwapOriginEvent.SwapReason getReason(ItemStack icon) {
        return PlayerSwapOriginEvent.SwapReason.get((String)icon.getItemMeta().getPersistentDataContainer().get(swapTypeKey, PersistentDataType.STRING));
    }

    public static Origin getOrigin(Player player) {
        if (player.getPersistentDataContainer().has(originKey)) {
            return OriginLoader.originNameMap.get(player.getPersistentDataContainer().get(originKey, PersistentDataType.STRING));
        }
        String name = originFileConfiguration.getString(player.getUniqueId().toString());
        if (name == null) {
            return null;
        }
        player.getPersistentDataContainer().set(originKey, PersistentDataType.STRING, (Object)name);
        return OriginLoader.originNameMap.get(name);
    }

    public static void setOrigin(Player player, @Nullable Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean resetPlayer) {
        PlayerSwapOriginEvent swapOriginEvent = new PlayerSwapOriginEvent(player, reason, resetPlayer, OriginSwapper.getOrigin(player), origin);
        if (!swapOriginEvent.callEvent()) {
            return;
        }
        if (swapOriginEvent.getNewOrigin() == null) {
            originFileConfiguration.set(player.getUniqueId().toString(), null);
            player.getPersistentDataContainer().remove(originKey);
            OriginSwapper.saveOrigins();
            OriginSwapper.resetPlayer(player, swapOriginEvent.isResetPlayer());
            return;
        }
        if (swapOriginEvent.getNewOrigin().getTeam() != null) {
            swapOriginEvent.getNewOrigin().getTeam().addPlayer((OfflinePlayer)player);
        }
        originFileConfiguration.set(player.getUniqueId().toString(), (Object)swapOriginEvent.getNewOrigin().getName().toLowerCase());
        player.getPersistentDataContainer().set(originKey, PersistentDataType.STRING, (Object)swapOriginEvent.getNewOrigin().getName().toLowerCase());
        OriginSwapper.saveOrigins();
        OriginSwapper.resetPlayer(player, swapOriginEvent.isResetPlayer());
    }

    public OriginSwapper() {
        originFile = new File(OriginsReborn.getInstance().getDataFolder(), "selected-origins.yml");
        if (!originFile.exists()) {
            boolean ignored = originFile.getParentFile().mkdirs();
            OriginsReborn.getInstance().saveResource("selected-origins.yml", false);
        }
        originFileConfiguration = new YamlConfiguration();
        try {
            originFileConfiguration.load(originFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveOrigins() {
        try {
            originFileConfiguration.save(originFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LineData {
        private final List<LineComponent> lines;

        public static List<LineComponent> makeLineFor(String text, LineComponent.LineType type) {
            StringBuilder result = new StringBuilder();
            StringBuilder rawResult = new StringBuilder();
            ArrayList<LineComponent> list = new ArrayList<LineComponent>();
            ArrayList<String> splitLines = new ArrayList<String>(Arrays.stream(text.split("\n", 2)).toList());
            StringBuilder otherPart = new StringBuilder();
            Object firstLine = (String)splitLines.remove(0);
            if (((String)firstLine).contains(" ") && OriginSwapper.getWidth((String)firstLine) > 140) {
                ArrayList<String> split = new ArrayList<String>(Arrays.stream(((String)firstLine).split(" ")).toList());
                StringBuilder firstPart = new StringBuilder((String)split.get(0));
                split.remove(0);
                boolean canAdd = true;
                for (String s : split) {
                    if (canAdd && OriginSwapper.getWidth(firstPart + " " + s) <= 140) {
                        firstPart.append(" ");
                        firstPart.append(s);
                        continue;
                    }
                    canAdd = false;
                    if (otherPart.length() > 0) {
                        otherPart.append(" ");
                    }
                    otherPart.append(s);
                }
                firstLine = firstPart.toString();
            }
            for (String s : splitLines) {
                if (otherPart.length() > 0) {
                    otherPart.append("\n");
                }
                otherPart.append(s);
            }
            if (type == LineComponent.LineType.DESCRIPTION) {
                firstLine = "\uf00a" + (String)firstLine;
            }
            for (ArrayList<String> arrayList : (ArrayList<String>)((String)firstLine).toCharArray()) {
                result.append((char)arrayList);
                rawResult.append(arrayList == 61450 ? "" : Character.valueOf(arrayList));
                result.append('\uf000');
            }
            rawResult.append(' ');
            Object finalText = firstLine;
            list.add(new LineComponent(((TextComponent)Component.text((String)result.toString()).color((TextColor)(type == LineComponent.LineType.TITLE ? NamedTextColor.WHITE : TextColor.fromHexString((String)"#CACACA")))).append((Component)Component.text((String)OriginSwapper.getInverse((String)finalText))), type, rawResult.toString()));
            if (otherPart.length() != 0) {
                list.addAll(LineData.makeLineFor(otherPart.toString(), type));
            }
            return list;
        }

        public LineData(Origin origin) {
            this.lines = new ArrayList<LineComponent>();
            this.lines.addAll(origin.getLineData());
            List<VisibleAbility> visibleAbilities = origin.getVisibleAbilities();
            int size = visibleAbilities.size();
            int count = 0;
            if (size > 0) {
                this.lines.add(new LineComponent());
            }
            for (VisibleAbility visibleAbility : visibleAbilities) {
                this.lines.addAll(visibleAbility.getTitle());
                this.lines.addAll(visibleAbility.getDescription());
                if (++count >= size) continue;
                this.lines.add(new LineComponent());
            }
        }

        public LineData(List<LineComponent> lines) {
            this.lines = lines;
        }

        public List<Component> getLines(int startingPoint) {
            ArrayList<Component> resultLines = new ArrayList<Component>();
            for (int i = startingPoint; i < startingPoint + 6 && i < this.lines.size(); ++i) {
                resultLines.add(this.lines.get(i).getComponent(i - startingPoint));
            }
            return resultLines;
        }

        public List<LineComponent> getRawLines() {
            return this.lines;
        }

        public static class LineComponent {
            private final Component component;
            private final LineType type;
            private final String rawText;
            private final boolean empty;

            public boolean isEmpty() {
                return this.empty;
            }

            public LineType getType() {
                return this.type;
            }

            public LineComponent(Component component, LineType type, String rawText) {
                this.component = component;
                this.type = type;
                this.rawText = rawText;
                this.empty = false;
            }

            public LineComponent() {
                this.type = LineType.DESCRIPTION;
                this.component = Component.empty();
                this.rawText = "";
                this.empty = true;
            }

            public String getRawText() {
                return this.rawText;
            }

            public Component getComponent(int lineNumber) {
                String formatted = "minecraft:%stext_line_%s".formatted(this.type == LineType.DESCRIPTION ? "" : "title_", lineNumber);
                return this.component.font(Key.key((String)formatted));
            }

            public static enum LineType {
                TITLE,
                DESCRIPTION;

            }
        }
    }
}

