/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.Origin;
import com.starshootercity.OriginsAddon;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.json.JSONArray;
import org.json.JSONObject;

public class OriginLoader {
    public static List<Origin> origins = new ArrayList<Origin>();
    public static Map<String, Origin> originNameMap = new HashMap<String, Origin>();
    private static final List<OriginsAddon> registeredAddons = new ArrayList<OriginsAddon>();
    private static final int BUFFER_SIZE = 4096;

    public static void register(OriginsAddon addon) {
        if (registeredAddons.contains((Object)addon)) {
            registeredAddons.remove((Object)addon);
            origins.removeIf(origin -> origin.getPlugin().getName().equals(addon.getName()));
        }
        registeredAddons.add(addon);
        OriginLoader.loadOriginsFor(addon);
        OriginLoader.sortOrigins();
    }

    public static void reloadOrigins() {
        origins = new ArrayList<Origin>();
        originNameMap = new HashMap<String, Origin>();
        for (OriginsAddon addon : registeredAddons) {
            OriginLoader.loadOriginsFor(addon);
        }
        OriginLoader.sortOrigins();
    }

    public static void sortOrigins() {
        origins.sort((o1, o2) -> {
            if (o1.getImpact() == o2.getImpact()) {
                if (o1.getPosition() == o2.getPosition()) {
                    return 0;
                }
                return o1.getPosition() > o2.getPosition() ? 1 : -1;
            }
            return o1.getImpact() > o2.getImpact() ? 1 : -1;
        });
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        int read;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private static void loadOriginsFor(OriginsAddon addon) {
        File[] files;
        File originFolder = new File(addon.getDataFolder(), "origins");
        if (!originFolder.exists()) {
            addon.saveResource("origins/", false);
            try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(addon.getFile()));){
                ZipEntry entry = inputStream.getNextEntry();
                while (entry != null) {
                    if (entry.getName().startsWith("origins/") && entry.getName().endsWith(".json")) {
                        OriginLoader.extractFile(inputStream, originFolder.getParentFile().getAbsolutePath() + "/" + entry.getName());
                    }
                    entry = inputStream.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((files = originFolder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            try (Scanner scanner = new Scanner(file);){
                String itemName;
                Object object;
                StringBuilder data = new StringBuilder();
                while (scanner.hasNext()) {
                    data.append(scanner.next());
                }
                final JSONObject object2 = new JSONObject(data.toString());
                boolean unchoosable = false;
                if (object2.has("unchoosable")) {
                    unchoosable = object2.getBoolean("unchoosable");
                }
                if ((object = object2.get("icon")) instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)object;
                    itemName = jsonObject.getString("item");
                } else {
                    itemName = object2.getString("icon");
                }
                Material material = Material.matchMaterial((String)itemName);
                if (material == null) {
                    material = Material.AIR;
                }
                ItemStack icon = new ItemStack(material);
                String name = file.getName().split("\\.")[0];
                StringBuilder formattedName = new StringBuilder();
                String[] parts = name.split("_");
                int num = 0;
                for (String part : parts) {
                    formattedName.append(part.substring(0, 1).toUpperCase()).append(part.substring(1));
                    if (++num >= parts.length) continue;
                    formattedName.append(" ");
                }
                Origin origin = new Origin(formattedName.toString(), icon, object2.getInt("order"), object2.getInt("impact"), (List<Key>)new ArrayList<Key>(){
                    {
                        if (object2.has("powers")) {
                            JSONArray array = object2.getJSONArray("powers");
                            for (Object o : array) {
                                this.add(Key.key((String)((String)o)));
                            }
                        }
                    }
                }, object2.getString("description"), addon, unchoosable, object2.has("priority") ? object2.getInt("priority") : 1);
                Origin previouslyRegisteredOrigin = originNameMap.get(name.replace("_", " "));
                if (previouslyRegisteredOrigin != null) {
                    if (previouslyRegisteredOrigin.getPriority() > origin.getPriority()) continue;
                    origins.remove(previouslyRegisteredOrigin);
                    originNameMap.remove(name.replace("_", " "));
                }
                origins.add(origin);
                originNameMap.put(name.replace("_", " "), origin);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

