/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.Ability;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Range;

public class Origin {
    private final ItemStack icon;
    private final int position;
    private final char impact;
    private final String name;
    private final int priority;
    private final boolean unchoosable;
    private final JavaPlugin plugin;
    private final List<Key> abilities;
    private final List<OriginSwapper.LineData.LineComponent> lineComponent;
    private final Team team;

    public List<OriginSwapper.LineData.LineComponent> getLineData() {
        return this.lineComponent;
    }

    public boolean isUnchoosable() {
        return this.unchoosable;
    }

    public int getPriority() {
        return this.priority;
    }

    public Team getTeam() {
        return this.team;
    }

    public Origin(String name, ItemStack icon, int position, @Range(from=0L, to=3L) int impact, List<Key> abilities, String description, JavaPlugin plugin, boolean unchoosable, int priority) {
        this.lineComponent = OriginSwapper.LineData.makeLineFor(description, OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
        this.name = name;
        if (OriginsReborn.getInstance().getConfig().getBoolean("display.enable-prefixes")) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team oldTeam = scoreboard.getTeam(name);
            if (oldTeam != null) {
                oldTeam.unregister();
            }
            this.team = scoreboard.registerNewTeam(name);
            this.team.displayName(((TextComponent)((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.DARK_GRAY)).append(Component.text((String)name).color((TextColor)NamedTextColor.WHITE))).append(Component.text((String)"] ").color((TextColor)NamedTextColor.DARK_GRAY)));
        } else {
            this.team = null;
        }
        this.abilities = abilities;
        this.icon = icon;
        this.position = position;
        this.unchoosable = unchoosable;
        this.impact = (char)(switch (impact) {
            case 0 -> 57346;
            case 1 -> 57347;
            case 2 -> 57348;
            default -> 57349;
        });
        this.plugin = plugin;
        this.priority = priority;
    }

    public List<VisibleAbility> getVisibleAbilities() {
        ArrayList<VisibleAbility> result = new ArrayList<VisibleAbility>();
        for (Key key : this.abilities) {
            Ability ability = AbilityRegister.abilityMap.get(key);
            if (!(ability instanceof VisibleAbility)) continue;
            VisibleAbility visibleAbility = (VisibleAbility)ability;
            result.add(visibleAbility);
        }
        return result;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public List<Ability> getAbilities() {
        return new ArrayList<Ability>(){
            {
                for (Key key : Origin.this.abilities) {
                    this.add(AbilityRegister.abilityMap.get(key));
                }
            }
        };
    }

    public boolean hasAbility(Key key) {
        return this.abilities.contains(key);
    }

    public char getImpact() {
        return this.impact;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public String getResourceURL() {
        String key = this.icon.getType().getKey().value();
        return "https://assets.mcasset.cloud/1.20.4/assets/minecraft/textures/%s/%s.png".formatted(this.icon.getType().isBlock() ? "block" : "item", key);
    }
}

