/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity;

import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.events.PlayerSwapOriginEvent;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class OrbOfOrigin
implements Listener {
    public static NamespacedKey orbKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "orb-of-origin");
    public static final ItemStack orb = new ItemStack(Material.NAUTILUS_SHELL){
        {
            ItemMeta meta = this.getItemMeta();
            meta.getPersistentDataContainer().set(orbKey, PersistentDataType.BOOLEAN, (Object)true);
            meta.setCustomModelData(Integer.valueOf(1));
            meta.displayName(((TextComponent)Component.text((String)"Orb of Origin").color((TextColor)NamedTextColor.AQUA)).decoration(TextDecoration.ITALIC, false));
            this.setItemMeta(meta);
        }
    };

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe != null && recipe.getResult().getType() == Material.CONDUIT) {
            for (ItemStack itemStack : event.getInventory().getMatrix()) {
                if (itemStack == null || itemStack.getItemMeta() == null || !itemStack.getItemMeta().getPersistentDataContainer().has(orbKey)) continue;
                event.getInventory().setResult(null);
            }
        }
    }

    public OrbOfOrigin() {
        Bukkit.removeRecipe((NamespacedKey)orbKey);
        FileConfiguration config = OriginsReborn.getInstance().getConfig();
        if (config.getBoolean("orb-of-origin.enable-recipe")) {
            ShapedRecipe shapedRecipe = new ShapedRecipe(orbKey, orb);
            shapedRecipe.shape(new String[]{"012", "345", "678"});
            int i = 0;
            List recipeData = config.getList("orb-of-origin.recipe");
            if (recipeData == null) {
                return;
            }
            for (Object line : recipeData) {
                for (String name : (List)line) {
                    Material material = Material.matchMaterial((String)name);
                    if (material == null) {
                        material = Material.AIR;
                    }
                    shapedRecipe.setIngredient(String.valueOf(i).charAt(0), material);
                    ++i;
                }
            }
            Bukkit.addRecipe((Recipe)shapedRecipe);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(orbKey)) {
            if (OriginSwapper.orbCooldown.containsKey(event.getPlayer()) && System.currentTimeMillis() - OriginSwapper.orbCooldown.get(event.getPlayer()) < 500L) {
                return;
            }
            ItemMeta heldMeta = event.getPlayer().getInventory().getItemInMainHand().getItemMeta();
            EquipmentSlot hand = EquipmentSlot.OFF_HAND;
            if (heldMeta != null && heldMeta.getPersistentDataContainer().has(orbKey)) {
                hand = EquipmentSlot.HAND;
            }
            event.getPlayer().swingHand(hand);
            OriginSwapper.openOriginSwapper(event.getPlayer(), PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, 0, 0);
        }
    }
}

