/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class TransformIntoZombifiedPiglin
implements VisibleAbility,
Listener {
    private final Map<Player, Integer> overworldTime = new HashMap<Player, Integer>();
    private final World nether = Bukkit.getWorld((String)OriginsReborn.getInstance().getConfig().getString("worlds.world_nether", "world_nether"));

    public String description() {
        return "You transform into a Zombified Piglin if you're out of the Nether for too long.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:transform_into_zombified_piglin");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (player.getWorld() == this.nether) {
                    this.overworldTime.put(player, 0);
                } else {
                    this.overworldTime.put(player, this.overworldTime.getOrDefault(player, 0) + 1);
                }
                if (this.overworldTime.getOrDefault(player, 0) >= 15) {
                    this.switchToZombifiedPiglin(player);
                }
            });
        }
    }

    private void switchToZombifiedPiglin(Player player) {
        this.overworldTime.put(player, 0);
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_PIGLIN_CONVERTED_TO_ZOMBIFIED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"zombified piglin"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a Zombified Piglin!").color((TextColor)NamedTextColor.YELLOW));
    }
}

