/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.originsmonsters.abilities.metamorphosis.MetamorphosisTemperature;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;

public class TransformIntoStray
implements VisibleAbility,
Listener {
    private final Map<Player, Integer> lastHadLowFreezeTime = new HashMap<Player, Integer>();

    public String description() {
        return "You transform into a Stray if you're in the cold for too long.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:transform_into_stray");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (player.getFreezeTicks() >= player.getMaxFreezeTicks()) {
                    this.lastHadLowFreezeTime.put(player, Bukkit.getCurrentTick());
                }
                if (Bukkit.getCurrentTick() - this.lastHadLowFreezeTime.getOrDefault(player, Bukkit.getCurrentTick()) >= 300) {
                    MetamorphosisTemperature.setTemperature(player, 25);
                }
                if (MetamorphosisTemperature.getTemperature(player) <= 25) {
                    this.switchToStray(player);
                }
            });
        }
    }

    private void switchToStray(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_SKELETON_CONVERTED_TO_STRAY, SoundCategory.PLAYERS, 1.0f, 1.0f);
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"stray"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a stray!").color((TextColor)NamedTextColor.YELLOW));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.FREEZE) {
            this.runForAbility(event.getEntity(), player -> event.setCancelled(true));
        }
    }
}

