/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class TransformIntoPiglin
implements VisibleAbility,
Listener {
    public String description() {
        return "You transform into a Piglin if you eat a golden apple when under the effect of a weakness potion.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:transform_into_piglin");
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() != Material.GOLDEN_APPLE) {
            return;
        }
        if (!event.getPlayer().hasPotionEffect(PotionEffectType.WEAKNESS)) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), this::switchToPiglin);
    }

    private void switchToPiglin(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_PIGLIN_CONVERTED_TO_ZOMBIFIED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"piglin"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a Piglin!").color((TextColor)NamedTextColor.YELLOW));
    }
}

