/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.originsmonsters.abilities.metamorphosis.MetamorphosisTemperature;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.jetbrains.annotations.NotNull;

public class TransformIntoHuskAndDrowned
implements VisibleAbility,
Listener {
    private final Map<Player, Integer> lastOutOfAirTime = new HashMap<Player, Integer>();

    public String description() {
        return "You transform into a Husk if you're in the desert for too long, and a Drowned if you're in the water for too long.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:transform_into_husk_and_drowned");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (MetamorphosisTemperature.getTemperature(player) >= 75) {
                    this.switchToHusk(player);
                }
            });
        }
    }

    private void switchToHusk(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_HUSK_CONVERTED_TO_ZOMBIE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"husk"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a husk!").color((TextColor)NamedTextColor.YELLOW));
    }

    @EventHandler
    public void onEntityAirChange(EntityAirChangeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.runForAbility((Entity)p, player -> {
                if (event.getAmount() > 0) {
                    this.lastOutOfAirTime.remove(player);
                } else {
                    event.setAmount(0);
                    this.lastOutOfAirTime.putIfAbsent(player, Bukkit.getCurrentTick());
                    if (Bukkit.getCurrentTick() - this.lastOutOfAirTime.get(player) >= 300) {
                        this.switchToDrowned(player);
                    }
                }
            });
        }
    }

    private void switchToDrowned(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_ZOMBIE_CONVERTED_TO_DROWNED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        MetamorphosisTemperature.setTemperature(player, Math.min(20, MetamorphosisTemperature.getTemperature(player)));
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"drowned"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a drowned!").color((TextColor)NamedTextColor.YELLOW));
    }
}

