/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MetamorphosisTemperature
implements CooldownAbility,
Listener {
    private static final NamespacedKey playerTemperatureKey = new NamespacedKey((Plugin)OriginsMonsters.getInstance(), "player-temperature");
    public static MetamorphosisTemperature INSTANCE = new MetamorphosisTemperature();
    private final String speedMultiplier = "speed_multiplier";

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:metamorphosis_temperature");
    }

    public static int getTemperature(Player player) {
        return (Integer)player.getPersistentDataContainer().getOrDefault(playerTemperatureKey, PersistentDataType.INTEGER, (Object)50);
    }

    public static void setTemperature(Player player, int amount) {
        player.getPersistentDataContainer().set(playerTemperatureKey, PersistentDataType.INTEGER, (Object)Math.max(0, Math.min(amount, 100)));
        INSTANCE.setCooldown(player, MetamorphosisTemperature.getTemperature(player));
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                double blockTemp = player.getLocation().getBlock().getTemperature();
                if (blockTemp <= 0.15) {
                    MetamorphosisTemperature.setTemperature(player, MetamorphosisTemperature.getTemperature(player) - (Integer)this.getConfigOption(OriginsMonsters.getInstance(), "speed_multiplier", ConfigManager.SettingType.INTEGER));
                } else if (blockTemp >= 1.75 && !OriginsReborn.getNMSInvoker().isUnderWater((LivingEntity)player)) {
                    MetamorphosisTemperature.setTemperature(player, MetamorphosisTemperature.getTemperature(player) + (Integer)this.getConfigOption(OriginsMonsters.getInstance(), "speed_multiplier", ConfigManager.SettingType.INTEGER));
                }
            });
        }
    }

    @EventHandler
    public void onPlayerSwapOrigin(PlayerSwapOriginEvent event) {
        if (List.of(PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN, PlayerSwapOriginEvent.SwapReason.DIED, PlayerSwapOriginEvent.SwapReason.COMMAND, PlayerSwapOriginEvent.SwapReason.INITIAL).contains(event.getReason())) {
            MetamorphosisTemperature.setTemperature(event.getPlayer(), 50);
        }
    }

    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(100, "metamorphosis_temperature", true, true);
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "speed_multiplier", Collections.singletonList("The speed at which temperature should change"), ConfigManager.SettingType.INTEGER, 1);
    }
}

