/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.originsmonsters.abilities.metamorphosis.MetamorphosisTemperature;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.jetbrains.annotations.NotNull;

public class HuskTransformIntoZombie
implements VisibleAbility,
Listener {
    private final Map<Player, Integer> lastOutOfAirTime = new HashMap<Player, Integer>();

    public String description() {
        return "You transform into a Zombie if you're in water for too long.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:husk_transform_into_zombie");
    }

    @EventHandler
    public void onEntityAirChange(EntityAirChangeEvent event) {
        this.runForAbility(event.getEntity(), player -> {
            if (event.getAmount() > 0) {
                this.lastOutOfAirTime.remove(player);
            } else {
                event.setAmount(0);
                this.lastOutOfAirTime.putIfAbsent(player, Bukkit.getCurrentTick());
                if (Bukkit.getCurrentTick() - this.lastOutOfAirTime.get(player) >= 300) {
                    this.switchToZombie(player);
                }
            }
        });
    }

    private void switchToZombie(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_HUSK_CONVERTED_TO_ZOMBIE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        MetamorphosisTemperature.setTemperature(player, Math.min(70, MetamorphosisTemperature.getTemperature(player)));
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"zombie"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a zombie!").color((TextColor)NamedTextColor.YELLOW));
    }
}

