/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities.metamorphosis;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.AddonLoader;
import com.starshootercity.Origin;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.events.PlayerSwapOriginEvent;
import com.starshootercity.originsmonsters.abilities.metamorphosis.MetamorphosisTemperature;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class DrownedTransformIntoZombie
implements VisibleAbility,
Listener {
    public String description() {
        return "You transform into a Zombie if you're in a warm area for too long.";
    }

    public String title() {
        return "Metamorphosis";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:drowned_transform_into_zombie");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (MetamorphosisTemperature.getTemperature(player) >= 30) {
                    this.switchToZombie(player);
                }
            });
        }
    }

    private void switchToZombie(Player player) {
        player.getLocation().getWorld().playSound((Entity)player, Sound.ENTITY_ZOMBIE_CONVERTED_TO_DROWNED, SoundCategory.PLAYERS, 1.0f, 1.0f);
        OriginSwapper.setOrigin((Player)player, (Origin)AddonLoader.getOrigin((String)"zombie"), (PlayerSwapOriginEvent.SwapReason)PlayerSwapOriginEvent.SwapReason.PLUGIN, (boolean)false, (String)"origin");
        player.sendMessage(Component.text((String)"You have transformed into a zombie!").color((TextColor)NamedTextColor.YELLOW));
    }
}

