/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.SavedPotionEffect;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.ShortcutUtils;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class WaterVision
implements VisibleAbility,
Listener {
    Map<Player, SavedPotionEffect> storedEffects = new HashMap<Player, SavedPotionEffect>();

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                if (OriginsReborn.getNMSInvoker().isUnderWater((LivingEntity)player)) {
                    PotionEffect effect = player.getPotionEffect(PotionEffectType.NIGHT_VISION);
                    boolean ambient = false;
                    boolean showParticles = false;
                    if (effect != null) {
                        ambient = effect.isAmbient();
                        showParticles = effect.hasParticles();
                        if (effect.getAmplifier() != -1) {
                            this.storedEffects.put(player, new SavedPotionEffect(effect, Bukkit.getCurrentTick()));
                            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        }
                    }
                    player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, ShortcutUtils.infiniteDuration(), -1, ambient, showParticles));
                } else {
                    PotionEffect effect;
                    if (player.hasPotionEffect(PotionEffectType.NIGHT_VISION) && (effect = player.getPotionEffect(PotionEffectType.NIGHT_VISION)) != null && effect.getAmplifier() == -1) {
                        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    }
                    if (this.storedEffects.containsKey(player)) {
                        effect = this.storedEffects.get(player);
                        this.storedEffects.remove(player);
                        PotionEffect potionEffect = effect.effect();
                        int time = potionEffect.getDuration() - (Bukkit.getCurrentTick() - effect.currentTime());
                        if (time > 0) {
                            player.addPotionEffect(new PotionEffect(potionEffect.getType(), time, potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles()));
                        }
                    }
                }
            });
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.MILK_BUCKET) {
            this.storedEffects.remove(event.getPlayer());
        }
    }

    public String title() {
        return "Water Vision";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:water_vision");
    }

    public String description() {
        return "Your vision underwater is perfect.";
    }
}

