/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import io.papermc.paper.tag.EntityTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Keyed;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.jetbrains.annotations.NotNull;

public class UndeadAlly
implements VisibleAbility,
Listener {
    private final Map<Player, List<Entity>> attackedEntities = new HashMap<Player, List<Entity>>();

    public String description() {
        return "Undead mobs don't attack you, unless you attack them first.";
    }

    public String title() {
        return "Undead Ally";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:undead_ally");
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        LivingEntity livingEntity;
        if (EntityTags.UNDEADS.isTagged((Keyed)event.getEntityType()) && (livingEntity = event.getTarget()) instanceof Player) {
            Player p = (Player)livingEntity;
            this.runForAbility((Entity)p, player -> {
                if (!((List)this.attackedEntities.getOrDefault(player, new ArrayList())).contains(event.getEntity())) {
                    event.setCancelled(true);
                }
            });
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player p;
            player = p = (Player)entity;
        } else {
            Projectile projectile;
            entity = event.getDamager();
            if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
                Player p;
                player = p = (Player)entity;
            } else {
                return;
            }
        }
        List playerHitEntities = this.attackedEntities.getOrDefault(player, new ArrayList());
        playerHitEntities.add(event.getEntity());
        this.attackedEntities.put(player, playerHitEntities);
    }
}

