/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.AttributeModifierAbility;
import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.events.PlayerLeftClickEvent;
import com.starshootercity.originsmonsters.OriginsMonsters;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TridentExpert
implements VisibleAbility,
Listener,
AttributeModifierAbility,
CooldownAbility {
    private final NamespacedKey riptideKey = new NamespacedKey((Plugin)OriginsMonsters.getInstance(), "riptide-trident");
    private final Map<Player, Integer> lastTridentEnabledTime = new HashMap<Player, Integer>();

    public String description() {
        return "You're a master of the trident, dealing +2 damage when you throw it, and +2 melee damage with it. You can also use channeling without thunder, and use riptide without rain/water at the price of extra durability.";
    }

    public String title() {
        return "Trident Expert";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:trident_expert");
    }

    public ItemStack fixTrident(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (item.getItemMeta() == null) {
            return item;
        }
        if (item.getItemMeta().getPersistentDataContainer().has(this.riptideKey)) {
            ItemMeta meta = item.getItemMeta();
            int level = (Integer)item.getItemMeta().getPersistentDataContainer().getOrDefault(this.riptideKey, PersistentDataType.INTEGER, (Object)1);
            meta.getPersistentDataContainer().remove(this.riptideKey);
            meta.addEnchant(Enchantment.RIPTIDE, level, false);
            meta.removeEnchant(Enchantment.FROST_WALKER);
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onPlayerStopUsingItem(PlayerStopUsingItemEvent event) {
        if (event.getItem().getType() != Material.TRIDENT) {
            return;
        }
        if (event.getTicksHeldFor() >= 10 && event.getItem().getItemMeta().getPersistentDataContainer().has(this.riptideKey)) {
            this.releaseUsing(this.fixTrident(event.getItem()), event.getPlayer().getWorld(), event.getPlayer());
            OriginsMonsters.getNMSInvoker().damageItem(event.getItem(), 10, event.getPlayer());
        } else {
            this.fixTrident(event.getItem());
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerJoinEvent event) {
        this.fixTrident(event.getPlayer().getInventory().getItemInMainHand());
        this.fixTrident(event.getPlayer().getInventory().getItemInOffHand());
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        ItemStack item = event.getPlayer().getInventory().getItem(event.getPreviousSlot());
        if (item != null && item.getType() == Material.TRIDENT) {
            this.fixTrident(item);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getPlayer().isInWaterOrRainOrBubbleColumn()) {
            return;
        }
        if (Bukkit.getCurrentTick() - this.lastTridentEnabledTime.getOrDefault(event.getPlayer(), Bukkit.getCurrentTick() - 400) >= 400) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != Material.TRIDENT) {
            return;
        }
        if (!event.getItem().getItemMeta().hasEnchant(Enchantment.RIPTIDE)) {
            return;
        }
        ItemMeta meta = event.getItem().getItemMeta();
        event.getItem().setItemMeta(meta);
        meta.getPersistentDataContainer().set(this.riptideKey, PersistentDataType.INTEGER, (Object)meta.getEnchantLevel(Enchantment.RIPTIDE));
        meta.removeEnchant(Enchantment.RIPTIDE);
        if (meta.getEnchants().isEmpty()) {
            meta.addEnchant(Enchantment.FROST_WALKER, 1, true);
        }
        event.getItem().setItemMeta(meta);
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        event.getItemDrop().setItemStack(this.fixTrident(event.getItemDrop().getItemStack()));
    }

    @EventHandler
    public void onPlayerLeftClick(PlayerLeftClickEvent event) {
        if (List.of(Material.AIR, Material.TRIDENT).contains(event.getPlayer().getInventory().getItemInMainHand().getType())) {
            this.runForAbility((Entity)event.getPlayer(), player -> {
                if (this.hasCooldown(player)) {
                    return;
                }
                this.setCooldown(player);
                this.lastTridentEnabledTime.put(player, Bukkit.getCurrentTick());
            });
        }
    }

    @NotNull
    public Attribute getAttribute() {
        return OriginsReborn.getNMSInvoker().getAttackDamageAttribute();
    }

    public double getAmount(Player player) {
        return player.getInventory().getItemInMainHand().getType() == Material.TRIDENT && Bukkit.getCurrentTick() - this.lastTridentEnabledTime.getOrDefault(player, Bukkit.getCurrentTick() - 400) < 400 ? 2.0 : 0.0;
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            Projectile projectile = event.getEntity();
            if (projectile instanceof Trident) {
                Trident trident = (Trident)projectile;
                this.runForAbility((Entity)player, p -> {
                    if (Bukkit.getCurrentTick() - this.lastTridentEnabledTime.getOrDefault(p, Bukkit.getCurrentTick() - 400) < 400) {
                        trident.setDamage(trident.getDamage() + 2.0);
                    }
                });
            }
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getHitEntity() == null) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            projectileSource = event.getEntity();
            if (projectileSource instanceof Trident) {
                Trident trident = (Trident)projectileSource;
                this.runForAbility((Entity)player, p -> {
                    if (Bukkit.getCurrentTick() - this.lastTridentEnabledTime.getOrDefault(p, Bukkit.getCurrentTick() - 400) < 400 && trident.getItemStack().getItemMeta().hasEnchant(Enchantment.CHANNELING)) {
                        event.getHitEntity().getWorld().strikeLightning(event.getHitEntity().getLocation());
                    }
                });
            }
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeModifier.Operation getOperation() {
        return AttributeModifier.Operation.ADD_NUMBER;
    }

    public void releaseUsing(ItemStack stack, World world, Player player) {
        int k = stack.getEnchantmentLevel(Enchantment.RIPTIDE);
        if (k > 0) {
            PlayerRiptideEvent event = new PlayerRiptideEvent(player, stack);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            float f = player.getLocation().getYaw();
            float f1 = player.getLocation().getPitch();
            double f2 = -Math.sin(f * ((float)Math.PI / 180)) * Math.cos(f1 * ((float)Math.PI / 180));
            double f3 = -Math.sin(f1 * ((float)Math.PI / 180));
            double f4 = Math.cos(f * ((float)Math.PI / 180)) * Math.cos(f1 * ((float)Math.PI / 180));
            double f5 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
            float f6 = 3.0f * ((1.0f + (float)k) / 4.0f);
            f2 *= (double)f6 / f5;
            f3 *= (double)f6 / f5;
            f4 *= (double)f6 / f5;
            if (player.isOnGround()) {
                OriginsMonsters.getNMSInvoker().tridentMove(player);
            }
            player.setVelocity(player.getVelocity().add(new Vector(f2, f3, f4)));
            OriginsMonsters.getNMSInvoker().startAutoSpinAttack(player, 20, 8.0f, stack);
            Sound soundeffect = k >= 3 ? Sound.ITEM_TRIDENT_RIPTIDE_3 : (k == 2 ? Sound.ITEM_TRIDENT_RIPTIDE_2 : Sound.ITEM_TRIDENT_RIPTIDE_1);
            world.playSound(player.getLocation(), soundeffect, 1.0f, 1.0f);
        }
    }

    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(400, "trident_expert", true);
    }
}

