/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SuperBartering
implements VisibleAbility,
Listener {
    private static final Random random = new Random();
    private final String minimumAmount = "minimum_amount";
    private final String maximumAmount = "maximum_amount";

    public String description() {
        return "You're brilliant at bartering after a lifetime of experience, every time you barter you get between 2 and 5 times as many valuables.";
    }

    public String title() {
        return "Bartering Master";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:super_bartering");
    }

    private static void throwItemsTowardPos(Piglin piglin, Collection<ItemStack> items, Location pos) {
        for (ItemStack itemStack : items) {
            OriginsMonsters.getNMSInvoker().throwItem(piglin, itemStack, pos.add(0.0, 1.0, 0.0));
        }
    }

    private static void throwItemsTowardPlayer(Piglin piglin, Player player, Collection<ItemStack> items) {
        SuperBartering.throwItemsTowardPos(piglin, items, player.getLocation());
    }

    private static Collection<ItemStack> getBarterResponseItems(Piglin piglin) {
        return LootTables.PIGLIN_BARTERING.getLootTable().populateLoot(random, new LootContext.Builder(piglin.getLocation()).lootedEntity((Entity)piglin).build());
    }

    @EventHandler
    public void onPiglinBarter(PiglinBarterEvent event) {
        Player p = OriginsMonsters.getNMSInvoker().getNearestVisiblePlayer(event.getEntity());
        if (p == null) {
            return;
        }
        this.runForAbility((Entity)p, player -> {
            int num = random.nextInt((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "minimum_amount", ConfigManager.SettingType.INTEGER), (Integer)this.getConfigOption(OriginsMonsters.getInstance(), "maximum_amount", ConfigManager.SettingType.INTEGER) + 1);
            for (int i = 0; i < num; ++i) {
                Collection<ItemStack> items = SuperBartering.getBarterResponseItems(event.getEntity());
                SuperBartering.throwItemsTowardPlayer(event.getEntity(), player, items);
            }
        });
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "minimum_amount", Collections.singletonList("The minimum number of extra barters"), ConfigManager.SettingType.INTEGER, 1);
        this.registerConfigOption(OriginsMonsters.getInstance(), "maximum_amount", Collections.singletonList("The maximum number of extra barters"), ConfigManager.SettingType.INTEGER, 3);
    }
}

