/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.events.PlayerLeftClickEvent;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SonicBoom
implements VisibleAbility,
Listener,
CooldownAbility {
    private final String damageDealt = "damage_dealt";

    public String description() {
        return "Every 30 seconds you can launch a sonic boom by hitting the air with your hand.";
    }

    public String title() {
        return "Sonic Boom";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:sonic_boom");
    }

    @EventHandler
    public void onPlayerLeftClick(PlayerLeftClickEvent event) {
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (this.hasCooldown(player)) {
                return;
            }
            this.setCooldown(player);
            Location currentLoc = player.getLocation().clone().add(0.0, 1.5, 0.0);
            ArrayList<Entity> hitEntities = new ArrayList<Entity>();
            for (int i = 0; i < 10; ++i) {
                currentLoc.add(currentLoc.getDirection());
                currentLoc.getWorld().spawnParticle(Particle.SONIC_BOOM, currentLoc, 1);
                for (Entity entity : currentLoc.getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (entity == player || hitEntities.contains(entity) || !(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    hitEntities.add(entity);
                    OriginsMonsters.getNMSInvoker().dealSonicBoomDamage(livingEntity, this.getDamageAmount(), player);
                }
            }
        });
    }

    public int getDamageAmount() {
        return (Integer)this.getConfigOption(OriginsMonsters.getInstance(), "damage_dealt", ConfigManager.SettingType.INTEGER);
    }

    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(600, "sonic_boom");
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "damage_dealt", Collections.singletonList("The amount of damage the Sonic Boom should deal"), ConfigManager.SettingType.INTEGER, 15);
    }
}

