/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class SenseMovement
implements VisibleAbility,
Listener {
    public String description() {
        return "You can see the outlines of nearby mobs, even through blocks.";
    }

    public String title() {
        return "Heightened Senses";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:sense_movement");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 20 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                for (Entity entity : player.getNearbyEntities(24.0, 24.0, 24.0)) {
                    if (entity == player || !(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    byte data = 0;
                    if (entity.isGlowing() || entity.getLocation().distance(player.getLocation()) <= 16.0) {
                        data = (byte)(data + 64);
                    }
                    if (entity.getFireTicks() > 0) {
                        data = (byte)(data + 1);
                    }
                    if (livingEntity.isInvisible()) {
                        data = (byte)(data + 32);
                    }
                    if (entity instanceof Player) {
                        Player checkedPlayer = (Player)entity;
                        if (checkedPlayer.isSneaking()) {
                            data = (byte)(data + 2);
                        }
                        if (checkedPlayer.isSprinting()) {
                            data = (byte)(data + 8);
                        }
                        if (checkedPlayer.isSwimming()) {
                            data = (byte)(data + 16);
                        }
                        if (checkedPlayer.isGliding()) {
                            data = (byte)(data - 128);
                        }
                    }
                    OriginsReborn.getNMSInvoker().sendEntityData(player, entity, data);
                }
            });
        }
    }
}

