/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class ScareVillagers
implements VisibleAbility,
Listener {
    private final NamespacedKey hitByPlayerKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "hit-by-player");

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:scare_villagers");
    }

    public String description() {
        return "Villagers are scared of you and refuse to trade with you.";
    }

    public String title() {
        return "Terrifying Monster";
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.fixVillager(villager);
        }
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (!(entity instanceof Villager)) continue;
            Villager villager = (Villager)entity;
            this.fixVillager(villager);
        }
    }

    public void fixVillager(Villager villager) {
        Bukkit.getMobGoals().addGoal((Mob)villager, 0, OriginsMonsters.getNMSInvoker().getVillagerAfraidGoal((LivingEntity)villager, arg_0 -> ((ScareVillagers)this).hasAbility(arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity().getType() != EntityType.CREEPER) return;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile) {
            Player shooter;
            Projectile projectile = (Projectile)entity;
            ProjectileSource projectileSource = projectile.getShooter();
            if (!(projectileSource instanceof Player)) return;
            player = shooter = (Player)projectileSource;
        } else {
            Player damager;
            entity = event.getDamager();
            if (!(entity instanceof Player)) return;
            player = damager = (Player)entity;
        }
        this.runForAbility((Entity)player, p -> event.getEntity().getPersistentDataContainer().set(this.hitByPlayerKey, PersistentDataType.STRING, (Object)p.getName()));
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.runForAbility((Entity)event.getPlayer(), player -> {
                event.setCancelled(true);
                villager.shakeHead();
            });
        }
    }
}

