/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class FearCats
implements VisibleAbility,
Listener {
    private final String weaknessStrength = "weakness_strength";

    public String description() {
        return "You get nausea and weakness when around cats.";
    }

    public String title() {
        return "Afraid of Cats";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:fear_cats");
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (event.getTickNumber() % 5 != 0) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                List entities = player.getNearbyEntities(8.0, 8.0, 8.0);
                entities.removeIf(entity -> entity.getType() != EntityType.CAT);
                if (!entities.isEmpty()) {
                    player.addPotionEffect(new PotionEffect(OriginsReborn.getNMSInvoker().getNauseaEffect(), 200, 0, false, true));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 200, ((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "weakness_strength", ConfigManager.SettingType.INTEGER)).intValue(), false, true));
                }
            });
        }
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "weakness_strength", Collections.singletonList("How strong the weakness effect should be"), ConfigManager.SettingType.INTEGER, 0);
    }
}

