/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.CooldownAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.cooldowns.Cooldowns;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Explosive
implements VisibleAbility,
Listener,
CooldownAbility {
    private final Map<Player, Integer> lastToggledSneak = new HashMap<Player, Integer>();
    private final String breakBlocks = "break_blocks";
    private final String causeFire = "cause_fire";
    private final String healthLost = "health_lost";

    public String description() {
        return "You can sacrifice some of your health to create an explosion every 15 seconds.";
    }

    public String title() {
        return "Explosive";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:explosive");
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.runForAbility((Entity)event.getPlayer(), player -> {
            if (this.hasCooldown(player)) {
                return;
            }
            if (!event.isSneaking()) {
                return;
            }
            if (Bukkit.getCurrentTick() - this.lastToggledSneak.getOrDefault(player, Bukkit.getCurrentTick() - 11) <= 10) {
                this.setCooldown(player);
                player.getLocation().createExplosion((Entity)player, 3.0f, ((Boolean)this.getConfigOption(OriginsMonsters.getInstance(), "cause_fire", ConfigManager.SettingType.BOOLEAN)).booleanValue(), ((Boolean)this.getConfigOption(OriginsMonsters.getInstance(), "break_blocks", ConfigManager.SettingType.BOOLEAN)).booleanValue());
                OriginsMonsters.getNMSInvoker().dealExplosionDamage(player, (Integer)this.getConfigOption(OriginsMonsters.getInstance(), "health_lost", ConfigManager.SettingType.INTEGER));
            } else {
                this.lastToggledSneak.put(player, Bukkit.getCurrentTick());
            }
        });
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "break_blocks", Collections.singletonList("Whether the explosion should break blocks"), ConfigManager.SettingType.BOOLEAN, true);
        this.registerConfigOption(OriginsMonsters.getInstance(), "cause_fire", Collections.singletonList("Whether the explosion should cause fire"), ConfigManager.SettingType.BOOLEAN, false);
        this.registerConfigOption(OriginsMonsters.getInstance(), "health_lost", Collections.singletonList("How much damage the player should take when creating an explosion"), ConfigManager.SettingType.INTEGER, 8);
    }

    public Cooldowns.CooldownInfo getCooldownInfo() {
        return new Cooldowns.CooldownInfo(300, "explosive");
    }
}

