/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.OriginsAddon;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.util.config.ConfigManager;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BurnInDay
implements VisibleAbility,
Listener {
    private final String burnWithHelmet = "burn_with_helmet";

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent ignored) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.runForAbility((Entity)p, player -> {
                ItemStack helm;
                Block block = player.getWorld().getHighestBlockAt(player.getLocation());
                while (MaterialTags.GLASS.isTagged(block) || MaterialTags.GLASS_PANES.isTagged(block) && (double)block.getY() >= player.getLocation().getY()) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                boolean height = (double)block.getY() < player.getLocation().getY();
                boolean isInOverworld = player.getWorld().getEnvironment().equals((Object)World.Environment.NORMAL);
                boolean day = player.getWorld().isDayTime();
                if (!((Boolean)this.getConfigOption((OriginsAddon)OriginsReborn.getInstance(), "burn_with_helmet", ConfigManager.SettingType.BOOLEAN)).booleanValue() && (helm = player.getInventory().getHelmet()) != null && !helm.getType().isAir()) {
                    return;
                }
                if (height && isInOverworld && day && !player.isInWaterOrRainOrBubbleColumn()) {
                    player.setFireTicks(Math.max(player.getFireTicks(), 60));
                }
            });
        }
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption((OriginsAddon)OriginsReborn.getInstance(), "burn_with_helmet", List.of("Whether the player should burn even when wearing a helmet"), ConfigManager.SettingType.BOOLEAN, true);
    }

    public String description() {
        return "You burn in daylight.";
    }

    public String title() {
        return "Photoallergic";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:burn_in_day");
    }
}

