/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BetterGoldWeapons
implements VisibleAbility,
Listener {
    private final String damageMultiplier = "damage_multiplier";

    public String description() {
        return "Your evil corruption of gold unlocks a dark power, making golden weapons unbreakable and much stronger.";
    }

    public String title() {
        return "Gold Desecration";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:better_gold_weapons");
    }

    @EventHandler
    public void onPlayerItemDamage(PlayerItemDamageEvent event) {
        if (event.getItem().getType() == Material.GOLDEN_SWORD || event.getItem().getType() == Material.GOLDEN_AXE) {
            this.runForAbility((Entity)event.getPlayer(), player -> event.setCancelled(true));
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        ItemStack item;
        Entity entity = event.getDamager();
        if (entity instanceof Player && ((item = (player = (Player)entity).getInventory().getItemInMainHand()).getType() == Material.GOLDEN_SWORD || item.getType() == Material.GOLDEN_AXE)) {
            this.runForAbility((Entity)player, p -> event.setDamage(event.getDamage() * (double)((Float)this.getConfigOption(OriginsMonsters.getInstance(), "damage_multiplier", ConfigManager.SettingType.FLOAT)).floatValue()));
        }
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "damage_multiplier", Collections.singletonList("Multiplier for damage done with golden tools"), ConfigManager.SettingType.FLOAT, Float.valueOf(2.5f));
    }
}

