/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.destroystokyo.paper.MaterialTags;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.types.AttributeModifierAbility;
import com.starshootercity.abilities.types.VisibleAbility;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BetterGoldArmour
implements VisibleAbility,
AttributeModifierAbility,
Listener {
    @NotNull
    public Attribute getAttribute() {
        return OriginsReborn.getNMSInvoker().getArmorAttribute();
    }

    public double getAmount(Player player) {
        int amount = 0;
        for (ItemStack item : player.getEquipment().getArmorContents()) {
            if (item == null) continue;
            if (item.getType() == Material.GOLDEN_HELMET) {
                ++amount;
                continue;
            }
            if (item.getType() == Material.GOLDEN_CHESTPLATE) {
                amount += 3;
                continue;
            }
            if (item.getType() == Material.GOLDEN_LEGGINGS) {
                amount += 3;
                continue;
            }
            if (item.getType() != Material.GOLDEN_BOOTS) continue;
            amount += 2;
        }
        return amount;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeModifier.Operation getOperation() {
        return AttributeModifier.Operation.ADD_NUMBER;
    }

    public String description() {
        return "Your adoration for gold unlocks its hidden power, making golden armor unbreakable and as strong as diamond.";
    }

    public String title() {
        return "Gold Worshipper";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:better_gold_armour");
    }

    @EventHandler
    public void onPlayerItemDamage(PlayerItemDamageEvent event) {
        if (!MaterialTags.ARMOR.isTagged(event.getItem())) {
            return;
        }
        if (!event.getItem().getType().toString().toLowerCase().contains("gold")) {
            return;
        }
        this.runForAbility((Entity)event.getPlayer(), player -> event.setCancelled(true));
    }
}

