/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ApplyWitherEffect
implements VisibleAbility,
Listener {
    private final String effectStrength = "strength";
    private final String effectDuration = "duration";

    public String description() {
        return "Anything you hit gets the Wither effect.";
    }

    public String title() {
        return "Wither";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:apply_wither_effect");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.runForAbility(event.getDamager(), player -> entity2.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, ((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "duration", ConfigManager.SettingType.INTEGER)).intValue(), ((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "strength", ConfigManager.SettingType.INTEGER)).intValue(), false, true)));
        }
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "strength", Collections.singletonList("Strength of the wither effect"), ConfigManager.SettingType.INTEGER, 0);
        this.registerConfigOption(OriginsMonsters.getInstance(), "duration", Collections.singletonList("Duration in ticks of the wither effect"), ConfigManager.SettingType.INTEGER, 200);
    }
}

