/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.originsmonsters.abilities;

import com.starshootercity.abilities.types.VisibleAbility;
import com.starshootercity.originsmonsters.OriginsMonsters;
import com.starshootercity.util.config.ConfigManager;
import java.util.Collections;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ApplyHungerEffect
implements VisibleAbility,
Listener {
    private final String effectStrength = "effect_strength";
    private final String effectDuration = "effect_duration";

    public String description() {
        return "Anything you hit gets the Hunger effect.";
    }

    public String title() {
        return "Hunger";
    }

    @NotNull
    public Key getKey() {
        return Key.key((String)"monsterorigins:apply_hunger_effect");
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.runForAbility(event.getDamager(), player -> entity2.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, ((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "effect_duration", ConfigManager.SettingType.INTEGER)).intValue(), ((Integer)this.getConfigOption(OriginsMonsters.getInstance(), "effect_strength", ConfigManager.SettingType.INTEGER)).intValue(), false, true)));
        }
    }

    public void initialize(JavaPlugin plugin) {
        this.registerConfigOption(OriginsMonsters.getInstance(), "effect_strength", Collections.singletonList("Strength of the hunger effect"), ConfigManager.SettingType.INTEGER, 200);
        this.registerConfigOption(OriginsMonsters.getInstance(), "effect_duration", Collections.singletonList("Duration in ticks of the hunger effect"), ConfigManager.SettingType.INTEGER, 0);
    }
}

