/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.sources;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.facet.FacetPointers;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRconCommandSource
implements CommandSource {
    private final Pointers pointers = (Pointers)((Pointers.Builder)super.pointers().toBuilder()).withDynamic(PermissionChecker.POINTER, () -> ((BaseRconCommandSource)this).getPermissionChecker()).withStatic(FacetPointers.TYPE, (Object)FacetPointers.Type.CONSOLE).build();
    private final ConcurrentLinkedQueue<Component> lines = new ConcurrentLinkedQueue();
    private final String command;
    private final Object plugin;
    private final Scheduler scheduler;
    private final long flushMs;
    private final int flushWaitCount;
    private final boolean consoleOutput;
    private final ComponentLogger componentLogger;

    public BaseRconCommandSource(String command, Object plugin, Scheduler scheduler, long flushMs, int flushWaitCount, boolean consoleOutput, ComponentLogger componentLogger) {
        this.command = command;
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.flushMs = flushMs;
        this.flushWaitCount = flushWaitCount;
        this.consoleOutput = consoleOutput;
        this.componentLogger = componentLogger;
    }

    public void sendMessage(@NotNull Identity identity, @NotNull Component message, @NotNull MessageType messageType) {
        this.lines.add(message);
        if (this.consoleOutput) {
            this.componentLogger.info(((TextComponent)Component.empty().append((Component)Component.text((String)("[/" + this.command + "] ")))).append(message));
        }
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }

    public CompletableFuture<List<Component>> outputAsync() {
        final CompletableFuture<List<Component>> result = new CompletableFuture<List<Component>>();
        final ArrayList messages = new ArrayList();
        Runnable poller = new Runnable(){
            private int wait;
            {
                this.wait = BaseRconCommandSource.this.flushWaitCount;
            }

            @Override
            public void run() {
                Component line;
                int count = 0;
                while ((line = BaseRconCommandSource.this.lines.poll()) != null) {
                    messages.add(line);
                    ++count;
                }
                int n = this.wait = count > 0 ? BaseRconCommandSource.this.flushWaitCount : this.wait - 1;
                if (this.wait > 0) {
                    BaseRconCommandSource.this.scheduler.buildTask(BaseRconCommandSource.this.plugin, (Runnable)this).delay(BaseRconCommandSource.this.flushMs, TimeUnit.MILLISECONDS).schedule();
                } else {
                    result.complete(messages);
                }
            }
        };
        poller.run();
        return result;
    }
}

