/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.lime.velocircon.config.RconConfig;
import org.lime.velocircon.server.RconServer;
import org.slf4j.Logger;

public class RconConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<AtomicBoolean> AUTH_ATTRIBUTE = AttributeKey.valueOf((String)"rcon.auth");
    private static final int MAX_PAYLOAD_LENGTH = 4096;
    private static final int INFO_PAYLOAD_LENGTH = 10;
    private static final Charset ENCODING = CharsetUtil.UTF_8;
    private final RconServer handler;
    private final Logger logger;
    private final RconConfig config;

    public RconConnectionHandler(RconServer handler, Logger logger, RconConfig config) {
        this.handler = handler;
        this.logger = logger;
        this.config = config;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.logger.info("New connection from {}", (Object)ctx.channel().remoteAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf in = (ByteBuf)msg;
        AtomicBoolean authed = (AtomicBoolean)ctx.channel().attr(AUTH_ATTRIBUTE).get();
        if (authed == null) {
            authed = new AtomicBoolean(false);
            ctx.channel().attr(AUTH_ATTRIBUTE).set((Object)authed);
        }
        try {
            while (in.readableBytes() >= 4) {
                in.markReaderIndex();
                int length = in.readIntLE();
                if (in.readableBytes() < length) {
                    in.resetReaderIndex();
                    return;
                }
                int requestId = in.readIntLE();
                int requestType = in.readIntLE();
                int payloadLength = length - 10;
                String payload = "";
                if (payloadLength > 0) {
                    payload = in.readCharSequence(payloadLength, ENCODING).toString();
                }
                in.skipBytes(2);
                this.handlePacket(ctx, requestId, requestType, payload, authed);
            }
        }
        finally {
            in.release();
        }
    }

    private void handlePacket(ChannelHandlerContext ctx, int requestId, int requestType, String payload, AtomicBoolean authed) {
        switch (requestType) {
            case 3: {
                this.logger.info("Handling authorization request");
                boolean success = payload != null && !payload.isEmpty() && payload.equals(this.handler.password());
                this.sendPacket(ctx, success ? requestId : -1, 2, "");
                authed.set(success);
                break;
            }
            case 2: {
                if (authed.get()) {
                    this.logger.info("Handling command '{}'", (Object)payload);
                    this.handler.execute(payload).handle((result, ex) -> {
                        if (ex != null) {
                            this.logger.error("Handling request '{}' error: {}", new Object[]{payload, ex.getMessage(), ex});
                            result = Component.text((String)("Error executing: " + payload + " (" + ex.getMessage() + ")")).color((TextColor)NamedTextColor.RED);
                        }
                        String postfix = this.config.colors ? "\u00a7r" : "";
                        LegacyComponentSerializer encoder = this.config.colors ? LegacyComponentSerializer.legacySection() : PlainTextComponentSerializer.plainText();
                        this.sendResponse(ctx, requestId, 0, (String)encoder.serialize(result) + postfix);
                        return true;
                    });
                    break;
                }
                this.logger.warn("Unauthorized command '{}'", (Object)payload);
                this.sendPacket(ctx, -1, 2, "");
                break;
            }
            default: {
                this.logger.warn("Unknown request type 0x{}", (Object)Integer.toHexString(requestType));
                this.sendResponse(ctx, requestId, 0, "Unknown request 0x" + Integer.toHexString(requestType));
            }
        }
    }

    private void sendPacket(ChannelHandlerContext ctx, int id, int type, String message) {
        byte[] messageBytes = message.getBytes(ENCODING);
        int packetLength = 8 + messageBytes.length + 2;
        ByteBuf buf = ctx.alloc().buffer(4 + packetLength);
        buf.writeIntLE(packetLength);
        buf.writeIntLE(id);
        buf.writeIntLE(type);
        buf.writeBytes(messageBytes);
        buf.writeByte(0);
        buf.writeByte(0);
        ctx.writeAndFlush((Object)buf);
    }

    private void sendResponse(ChannelHandlerContext ctx, int id, int type, String message) {
        byte[] messageBytes = message.getBytes(ENCODING);
        int maxChunk = 4086;
        for (int i = 0; i < messageBytes.length; i += maxChunk) {
            int len = Math.min(maxChunk, messageBytes.length - i);
            String chunk = new String(messageBytes, i, len, ENCODING);
            this.sendPacket(ctx, id, type, chunk);
        }
        if (messageBytes.length == 0) {
            this.sendPacket(ctx, id, type, "");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("Exception while parsing input", cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.logger.info("Connection from {} closed", (Object)ctx.channel().remoteAddress());
    }
}

