/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.lime.velocircon.config.RconConfig;
import org.lime.velocircon.server.NativeTransportType;
import org.lime.velocircon.server.RconConnectionHandler;
import org.lime.velocircon.server.RconServer;
import org.lime.velocircon.utils.NettyFutureUtils;
import org.slf4j.Logger;

public class RconBinder
implements Closeable {
    private final NativeTransportType transportType = NativeTransportType.bestType();
    private final EventLoopGroup bossGroup = this.transportType.createEventLoopGroup(NativeTransportType.Type.BOSS);
    private final EventLoopGroup workerGroup = this.transportType.createEventLoopGroup(NativeTransportType.Type.WORKER);
    private final RconServer rconHandler;
    private final Logger logger;

    public RconBinder(RconServer rconHandler, Logger logger) {
        this.rconHandler = rconHandler;
        this.logger = logger;
    }

    public CompletableFuture<ChannelGroup> bind(InetSocketAddress address, RconConfig config) {
        DefaultChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        ServerBootstrap bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channelFactory(this.transportType.serverSocketChannelFactory())).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>((ChannelGroup)channels, config){
            final /* synthetic */ ChannelGroup val$channels;
            final /* synthetic */ RconConfig val$config;
            {
                this.val$channels = channelGroup;
                this.val$config = rconConfig;
            }

            protected void initChannel(Channel ch) {
                this.val$channels.add((Object)ch);
                ch.pipeline().addLast(new ChannelHandler[]{new RconConnectionHandler(RconBinder.this.rconHandler, RconBinder.this.logger, this.val$config)});
            }
        }).localAddress((SocketAddress)address);
        return ((CompletableFuture)NettyFutureUtils.toCompletableFuture(bootstrap.bind(), ChannelFuture::channel).handle((arg_0, arg_1) -> this.lambda$bind$0((ChannelGroup)channels, arg_0, arg_1))).thenCompose(v -> v);
    }

    @Override
    public void close() {
        this.bossGroup.close();
        this.workerGroup.close();
    }

    private /* synthetic */ CompletableFuture lambda$bind$0(ChannelGroup channels, Channel channel, Throwable ex) {
        if (ex != null) {
            this.logger.error("Failed to bind RCON server", ex);
            return CompletableFuture.failedFuture(ex);
        }
        this.logger.info("RCON server bound to {}", (Object)channel.localAddress());
        channels.add((Object)channel);
        return CompletableFuture.completedFuture(channels);
    }
}

