/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.permissions;

import com.velocitypowered.api.permission.Tristate;
import java.util.ArrayList;
import java.util.Collection;
import org.lime.velocircon.config.RconConfig;
import org.lime.velocircon.permissions.LuckPermsPermissionFactory;
import org.lime.velocircon.permissions.RegexPermissionFactory;
import org.slf4j.Logger;

public interface PermissionFactory {
    public Tristate check(String var1);

    public static Collection<PermissionFactory> load(RconConfig config, Logger logger) {
        ArrayList<PermissionFactory> permissionFactories = new ArrayList<PermissionFactory>();
        try {
            RconConfig.Permissions.LuckPerms luckPerms = config.permissions.luckPerms;
            if (luckPerms.enable) {
                Class.forName("net.luckperms.api.LuckPerms");
                permissionFactories.add(LuckPermsPermissionFactory.create(luckPerms.group));
                logger.info("LuckPerms permission provider loaded");
            } else {
                logger.info("LuckPerms permission provider disabled");
            }
        }
        catch (ClassNotFoundException ignored) {
            logger.error("LuckPerms permission provider not loaded. LuckPerms not found");
        }
        RconConfig.Permissions.Regex regex = config.permissions.regex;
        if (regex.enable) {
            permissionFactories.add(RegexPermissionFactory.create(regex.regex));
            logger.info("Regex permission provider loaded");
        } else {
            logger.info("Regex permission provider disabled");
        }
        return permissionFactories;
    }
}

