/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class EnvLoader {
    private final String separator;
    private final String prefixWithSeparator;
    private final int prefixWithSeparatorLength;
    private final Converter<String, String> nameConverter;

    public EnvLoader(String prefix, String separator, CaseFormat envCaseFormat, CaseFormat fieldCaseFormat) {
        this.nameConverter = envCaseFormat.converterTo(fieldCaseFormat);
        this.separator = separator;
        this.prefixWithSeparator = prefix + separator;
        this.prefixWithSeparatorLength = this.prefixWithSeparator.length();
    }

    public Optional<ConfigurationNode> loadOptional() {
        BasicConfigurationNode root = BasicConfigurationNode.root();
        AtomicBoolean hasValue = new AtomicBoolean(false);
        System.getenv().forEach((arg_0, arg_1) -> this.lambda$loadOptional$0((ConfigurationNode)root, hasValue, arg_0, arg_1));
        return hasValue.get() ? Optional.of(root) : Optional.empty();
    }

    private /* synthetic */ void lambda$loadOptional$0(ConfigurationNode root, AtomicBoolean hasValue, String key, String value) {
        if (!key.startsWith(this.prefixWithSeparator)) {
            return;
        }
        String path = key.substring(this.prefixWithSeparatorLength);
        String[] parts = path.split(this.separator);
        ConfigurationNode node = root;
        for (String part : parts) {
            node = node.node(new Object[]{this.nameConverter.convert((Object)part)});
        }
        try {
            node.set((Object)value);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error load " + key + " environment", e);
        }
        hasValue.set(true);
    }
}

