/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon;

import com.google.common.collect.Iterables;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.group.ChannelGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.translation.GlobalTranslator;
import org.jetbrains.annotations.Nullable;
import org.lime.velocircon.config.ConfigLoader;
import org.lime.velocircon.config.RconConfig;
import org.lime.velocircon.permissions.PermissionFactory;
import org.lime.velocircon.server.RconBinder;
import org.lime.velocircon.server.RconServer;
import org.lime.velocircon.sources.BaseRconCommandSource;
import org.lime.velocircon.sources.PermissibleRconCommandSource;
import org.lime.velocircon.sources.RootRconCommandSource;
import org.lime.velocircon.utils.NettyFutureUtils;
import org.slf4j.Logger;

public class RconService
implements RconServer {
    private static final long FLUSH_MILLISECONDS = 300L;
    private static final int FLUSH_WAIT_COUNT = 3;
    private final Object plugin;
    private final ProxyServer server;
    private final ConfigLoader<RconConfig> configLoader;
    private final RconBinder binder;
    private final Logger logger;
    private final ComponentLogger componentLogger;
    private Collection<PermissionFactory> permissionFactories = Collections.emptyList();
    @Nullable
    private ChannelGroup channels;
    private String password;
    private boolean consoleOutput;

    public RconService(Object plugin, ProxyServer server, ConfigLoader<RconConfig> configLoader, Logger logger, ComponentLogger componentLogger) {
        this.plugin = plugin;
        this.server = server;
        this.configLoader = configLoader;
        this.logger = logger;
        this.componentLogger = componentLogger;
        this.binder = new RconBinder(this, logger);
    }

    public CompletableFuture<Void> reloadConfig() throws IOException {
        RconConfig config = this.configLoader.load();
        InetSocketAddress address = new InetSocketAddress(config.host, config.port);
        return ((CompletableFuture)this.disable().handle((disabled, e) -> {
            if (!config.enable) {
                return CompletableFuture.completedFuture(null);
            }
            this.permissionFactories = PermissionFactory.load(config, this.logger);
            this.password = config.password;
            this.consoleOutput = config.consoleOutput;
            return this.binder.bind(address, config).handle((channel, ex) -> {
                if (channel != null) {
                    this.channels = channel;
                }
                return null;
            });
        })).thenCompose(v -> v);
    }

    public CompletableFuture<Void> enable() throws IOException {
        return this.reloadConfig();
    }

    public CompletableFuture<Void> disable() {
        this.password = null;
        this.permissionFactories = Collections.emptyList();
        return Optional.ofNullable(this.channels).map(v -> {
            this.logger.info("Shutting down RCON server...");
            return v.close();
        }).map(NettyFutureUtils::toCompletableFuture).orElseGet(() -> CompletableFuture.completedFuture(null)).whenComplete((v, ex) -> {
            if (ex != null) {
                this.logger.error("Error RCON shutting down", ex);
            }
            this.channels = null;
        });
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public CompletableFuture<Component> execute(String command) {
        BaseRconCommandSource source = this.permissionFactories.isEmpty() ? new RootRconCommandSource(command, this.plugin, this.server.getScheduler(), 300L, 3, this.consoleOutput, this.componentLogger) : new PermissibleRconCommandSource(command, this.plugin, this.server.getScheduler(), this.permissionFactories, 300L, 3, this.consoleOutput, this.componentLogger);
        return ((CompletableFuture)this.server.getCommandManager().executeAsync((CommandSource)source, command).handleAsync((state, ex) -> source.outputAsync().handleAsync((output, exx) -> {
            Iterable lines = Objects.requireNonNullElseGet(output, Collections::emptyList);
            if (ex != null) {
                lines = Iterables.concat((Iterable)lines, Collections.singleton((TextComponent)Component.text((String)"Internal server error").color((TextColor)NamedTextColor.RED)));
            } else if (!state.booleanValue()) {
                lines = Iterables.concat(Collections.singleton((TextComponent)Component.text((String)"No such command").color((TextColor)NamedTextColor.RED)), (Iterable)lines);
            }
            Component result = Component.join((JoinConfiguration)JoinConfiguration.newlines(), (Iterable)lines);
            return GlobalTranslator.render((Component)result, (Locale)Locale.getDefault());
        }))).thenCompose(v -> v);
    }
}

