/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon;

import com.google.inject.Inject;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.nio.file.Path;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.lime.velocircon.Commands;
import org.lime.velocircon.ConfigLoader;
import org.lime.velocircon.RconConfig;
import org.lime.velocircon.RconService;
import org.lime.velocircon.bstats.velocity.Metrics;
import org.slf4j.Logger;

@Plugin(id="velocircon", name="Velocircon", version="1.0.5", description="Enable RCON Protocol support on Velocity", authors={"Lime"}, dependencies={@Dependency(id="luckperms", optional=true)})
public class Velocircon {
    public final ProxyServer proxy;
    public final Logger logger;
    public final Path dataFolder;
    private final Metrics.Factory metricsFactory;
    public final RconService rconService;

    @Inject
    public Velocircon(ProxyServer proxy, Logger logger, ComponentLogger componentLogger, @DataDirectory Path dataFolder, Metrics.Factory metricsFactory) throws IOException {
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.metricsFactory = metricsFactory;
        this.rconService = new RconService(this, proxy, ConfigLoader.create(dataFolder, "rcon", new RconConfig()), logger, componentLogger);
    }

    @Subscribe
    public EventTask onInitialize(ProxyInitializeEvent event) throws IOException {
        this.metricsFactory.make(this, 26312);
        Commands.register(this, this.proxy, this.rconService);
        return EventTask.resumeWhenComplete(this.rconService.enable());
    }

    @Subscribe
    public EventTask onShutdown(ProxyShutdownEvent event) {
        return EventTask.resumeWhenComplete(this.rconService.disable());
    }
}

