/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigLoader<T> {
    private final Path file;
    private final Class<T> clazz;
    private final YamlConfigurationLoader loader;
    private final ObjectMapper<T> mapper;

    private ConfigLoader(Path file, Class<T> clazz, T defaultValue) throws IOException {
        this.file = file;
        this.clazz = clazz;
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file)).indent(2).nodeStyle(NodeStyle.BLOCK).build();
        this.mapper = ObjectMapper.factory().get(clazz);
        if (!this.file.toFile().exists()) {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            this.save(defaultValue);
        } else {
            this.update(defaultValue);
        }
    }

    private ConfigLoader(Path folder, String name, Class<T> clazz, T defaultValue) throws IOException {
        this(folder.resolve(name + ".yml"), clazz, defaultValue);
    }

    private void update(T defaultValue) throws IOException {
        ConfigurationNode node = this.loader.createNode();
        this.mapper.save(defaultValue, node);
        ConfigurationNode updated = this.loader.load();
        updated.mergeFrom(node);
        this.loader.save(updated);
    }

    public void save(T value) throws IOException {
        ConfigurationNode node = this.loader.createNode();
        this.mapper.save(value, node);
        this.loader.save(node);
    }

    public T load() throws IOException {
        return (T)this.mapper.load(this.loader.load());
    }

    public Class<T> clazz() {
        return this.clazz;
    }

    public Path file() {
        return this.file;
    }

    public static <T> ConfigLoader<T> create(Path file, Class<T> clazz, T defaultValue) throws IOException {
        return new ConfigLoader<T>(file, clazz, defaultValue);
    }

    public static <T> ConfigLoader<T> create(Path folder, String name, Class<T> clazz, T defaultValue) throws IOException {
        return new ConfigLoader<T>(folder, name, clazz, defaultValue);
    }

    public static <T> ConfigLoader<T> create(Path file, T defaultValue) throws IOException {
        return ConfigLoader.create(file, defaultValue.getClass(), defaultValue);
    }

    public static <T> ConfigLoader<T> create(Path folder, String name, T defaultValue) throws IOException {
        return ConfigLoader.create(folder, name, defaultValue.getClass(), defaultValue);
    }
}

