/*
 * Decompiled with CFR 0.152.
 */
package org.lime.velocircon.permissions;

import com.velocitypowered.api.permission.Tristate;
import java.util.Optional;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.query.QueryOptions;
import org.lime.velocircon.permissions.PermissionFactory;

public record LuckPermsPermissionFactory(LuckPerms luckPerms, String groupName) implements PermissionFactory
{
    public static LuckPermsPermissionFactory create(String groupName) {
        return new LuckPermsPermissionFactory(LuckPermsProvider.get(), groupName);
    }

    @Override
    public Tristate check(String permission) {
        if (this.groupName == null || this.groupName.equals("*") || this.groupName.isBlank()) {
            return Tristate.TRUE;
        }
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(this.groupName)).map(v -> v.getCachedData().getPermissionData(QueryOptions.nonContextual()).checkPermission(permission)).map(v -> switch (v) {
            case net.luckperms.api.util.Tristate.TRUE -> Tristate.TRUE;
            case net.luckperms.api.util.Tristate.FALSE -> Tristate.FALSE;
            default -> Tristate.UNDEFINED;
        }).orElse(Tristate.UNDEFINED);
    }
}

